/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.DataSetExportSummary;
import software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataSetExportTaskResponse
extends M2Response
implements ToCopyableBuilder<Builder, GetDataSetExportTaskResponse> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetDataSetExportTaskResponse.getter(GetDataSetExportTaskResponse::kmsKeyArn)).setter(GetDataSetExportTaskResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDataSetExportTaskResponse.getter(GetDataSetExportTaskResponse::statusAsString)).setter(GetDataSetExportTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetDataSetExportTaskResponse.getter(GetDataSetExportTaskResponse::statusReason)).setter(GetDataSetExportTaskResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<DataSetExportSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(GetDataSetExportTaskResponse.getter(GetDataSetExportTaskResponse::summary)).setter(GetDataSetExportTaskResponse.setter(Builder::summary)).constructor(DataSetExportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(GetDataSetExportTaskResponse.getter(GetDataSetExportTaskResponse::taskId)).setter(GetDataSetExportTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SUMMARY_FIELD, TASK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataSetExportTaskResponse.memberNameToFieldInitializer();
    private final String kmsKeyArn;
    private final String status;
    private final String statusReason;
    private final DataSetExportSummary summary;
    private final String taskId;

    private GetDataSetExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyArn = builder.kmsKeyArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.summary = builder.summary;
        this.taskId = builder.taskId;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final DataSetTaskLifecycle status() {
        return DataSetTaskLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final DataSetExportSummary summary() {
        return this.summary;
    }

    public final String taskId() {
        return this.taskId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSetExportTaskResponse)) {
            return false;
        }
        GetDataSetExportTaskResponse other = (GetDataSetExportTaskResponse)((Object)obj);
        return Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataSetExportTaskResponse").add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Summary", (Object)this.summary()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataSetExportTaskResponse, T> g) {
        return obj -> g.apply((GetDataSetExportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private String kmsKeyArn;
        private String status;
        private String statusReason;
        private DataSetExportSummary summary;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSetExportTaskResponse model) {
            super(model);
            this.kmsKeyArn(model.kmsKeyArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.summary(model.summary);
            this.taskId(model.taskId);
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSetTaskLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final DataSetExportSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(DataSetExportSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(DataSetExportSummary summary) {
            this.summary = summary;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public GetDataSetExportTaskResponse build() {
            return new GetDataSetExportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataSetExportTaskResponse> {
        public Builder kmsKeyArn(String var1);

        public Builder status(String var1);

        public Builder status(DataSetTaskLifecycle var1);

        public Builder statusReason(String var1);

        public Builder summary(DataSetExportSummary var1);

        default public Builder summary(Consumer<DataSetExportSummary.Builder> summary) {
            return this.summary((DataSetExportSummary)((DataSetExportSummary.Builder)DataSetExportSummary.builder().applyMutation(summary)).build());
        }

        public Builder taskId(String var1);
    }
}

