/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.DataSetExportTask;
import software.amazon.awssdk.services.m2.model.DataSetExportTaskListCopier;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSetExportHistoryResponse
extends M2Response
implements ToCopyableBuilder<Builder, ListDataSetExportHistoryResponse> {
    private static final SdkField<List<DataSetExportTask>> DATA_SET_EXPORT_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSetExportTasks").getter(ListDataSetExportHistoryResponse.getter(ListDataSetExportHistoryResponse::dataSetExportTasks)).setter(ListDataSetExportHistoryResponse.setter(Builder::dataSetExportTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetExportTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetExportTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataSetExportHistoryResponse.getter(ListDataSetExportHistoryResponse::nextToken)).setter(ListDataSetExportHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_EXPORT_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataSetExportHistoryResponse.memberNameToFieldInitializer();
    private final List<DataSetExportTask> dataSetExportTasks;
    private final String nextToken;

    private ListDataSetExportHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetExportTasks = builder.dataSetExportTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataSetExportTasks() {
        return this.dataSetExportTasks != null && !(this.dataSetExportTasks instanceof SdkAutoConstructList);
    }

    public final List<DataSetExportTask> dataSetExportTasks() {
        return this.dataSetExportTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetExportTasks() ? this.dataSetExportTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetExportHistoryResponse)) {
            return false;
        }
        ListDataSetExportHistoryResponse other = (ListDataSetExportHistoryResponse)((Object)obj);
        return this.hasDataSetExportTasks() == other.hasDataSetExportTasks() && Objects.equals(this.dataSetExportTasks(), other.dataSetExportTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSetExportHistoryResponse").add("DataSetExportTasks", this.hasDataSetExportTasks() ? this.dataSetExportTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSetExportTasks": {
                return Optional.ofNullable(clazz.cast(this.dataSetExportTasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSetExportTasks", DATA_SET_EXPORT_TASKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetExportHistoryResponse, T> g) {
        return obj -> g.apply((ListDataSetExportHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private List<DataSetExportTask> dataSetExportTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetExportHistoryResponse model) {
            super(model);
            this.dataSetExportTasks(model.dataSetExportTasks);
            this.nextToken(model.nextToken);
        }

        public final List<DataSetExportTask.Builder> getDataSetExportTasks() {
            List<DataSetExportTask.Builder> result = DataSetExportTaskListCopier.copyToBuilder(this.dataSetExportTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetExportTasks(Collection<DataSetExportTask.BuilderImpl> dataSetExportTasks) {
            this.dataSetExportTasks = DataSetExportTaskListCopier.copyFromBuilder(dataSetExportTasks);
        }

        @Override
        public final Builder dataSetExportTasks(Collection<DataSetExportTask> dataSetExportTasks) {
            this.dataSetExportTasks = DataSetExportTaskListCopier.copy(dataSetExportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetExportTasks(DataSetExportTask ... dataSetExportTasks) {
            this.dataSetExportTasks(Arrays.asList(dataSetExportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetExportTasks(Consumer<DataSetExportTask.Builder> ... dataSetExportTasks) {
            this.dataSetExportTasks(Stream.of(dataSetExportTasks).map(c -> (DataSetExportTask)((DataSetExportTask.Builder)DataSetExportTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSetExportHistoryResponse build() {
            return new ListDataSetExportHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSetExportHistoryResponse> {
        public Builder dataSetExportTasks(Collection<DataSetExportTask> var1);

        public Builder dataSetExportTasks(DataSetExportTask ... var1);

        public Builder dataSetExportTasks(Consumer<DataSetExportTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

