/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle;
import software.amazon.awssdk.services.m2.model.ApplicationLifecycle;
import software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle;
import software.amazon.awssdk.services.m2.model.EngineType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(ApplicationSummary.getter(ApplicationSummary::applicationArn)).setter(ApplicationSummary.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ApplicationSummary.getter(ApplicationSummary::applicationId)).setter(ApplicationSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("applicationVersion").getter(ApplicationSummary.getter(ApplicationSummary::applicationVersion)).setter(ApplicationSummary.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ApplicationSummary.getter(ApplicationSummary::creationTime)).setter(ApplicationSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(ApplicationSummary.getter(ApplicationSummary::deploymentStatusAsString)).setter(ApplicationSummary.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ApplicationSummary.getter(ApplicationSummary::description)).setter(ApplicationSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineType").getter(ApplicationSummary.getter(ApplicationSummary::engineTypeAsString)).setter(ApplicationSummary.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(ApplicationSummary.getter(ApplicationSummary::environmentId)).setter(ApplicationSummary.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartTime").getter(ApplicationSummary.getter(ApplicationSummary::lastStartTime)).setter(ApplicationSummary.setter(Builder::lastStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ApplicationSummary.getter(ApplicationSummary::name)).setter(ApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ApplicationSummary.getter(ApplicationSummary::roleArn)).setter(ApplicationSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ApplicationSummary.getter(ApplicationSummary::statusAsString)).setter(ApplicationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionStatus").getter(ApplicationSummary.getter(ApplicationSummary::versionStatusAsString)).setter(ApplicationSummary.setter(Builder::versionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_ID_FIELD, APPLICATION_VERSION_FIELD, CREATION_TIME_FIELD, DEPLOYMENT_STATUS_FIELD, DESCRIPTION_FIELD, ENGINE_TYPE_FIELD, ENVIRONMENT_ID_FIELD, LAST_START_TIME_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, VERSION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationArn;
    private final String applicationId;
    private final Integer applicationVersion;
    private final Instant creationTime;
    private final String deploymentStatus;
    private final String description;
    private final String engineType;
    private final String environmentId;
    private final Instant lastStartTime;
    private final String name;
    private final String roleArn;
    private final String status;
    private final String versionStatus;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.creationTime = builder.creationTime;
        this.deploymentStatus = builder.deploymentStatus;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.environmentId = builder.environmentId;
        this.lastStartTime = builder.lastStartTime;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.versionStatus = builder.versionStatus;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Integer applicationVersion() {
        return this.applicationVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ApplicationDeploymentLifecycle deploymentStatus() {
        return ApplicationDeploymentLifecycle.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String description() {
        return this.description;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Instant lastStartTime() {
        return this.lastStartTime;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ApplicationLifecycle status() {
        return ApplicationLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApplicationVersionLifecycle versionStatus() {
        return ApplicationVersionLifecycle.fromValue(this.versionStatus);
    }

    public final String versionStatusAsString() {
        return this.versionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationVersion(), other.applicationVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.versionStatusAsString(), other.versionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationId", (Object)this.applicationId()).add("ApplicationVersion", (Object)this.applicationVersion()).add("CreationTime", (Object)this.creationTime()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("Description", (Object)this.description()).add("EngineType", (Object)this.engineTypeAsString()).add("EnvironmentId", (Object)this.environmentId()).add("LastStartTime", (Object)this.lastStartTime()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("VersionStatus", (Object)this.versionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "lastStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastStartTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "versionStatus": {
                return Optional.ofNullable(clazz.cast(this.versionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationVersion", APPLICATION_VERSION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engineType", ENGINE_TYPE_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("lastStartTime", LAST_START_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("versionStatus", VERSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationArn;
        private String applicationId;
        private Integer applicationVersion;
        private Instant creationTime;
        private String deploymentStatus;
        private String description;
        private String engineType;
        private String environmentId;
        private Instant lastStartTime;
        private String name;
        private String roleArn;
        private String status;
        private String versionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationArn(model.applicationArn);
            this.applicationId(model.applicationId);
            this.applicationVersion(model.applicationVersion);
            this.creationTime(model.creationTime);
            this.deploymentStatus(model.deploymentStatus);
            this.description(model.description);
            this.engineType(model.engineType);
            this.environmentId(model.environmentId);
            this.lastStartTime(model.lastStartTime);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.versionStatus(model.versionStatus);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getApplicationVersion() {
            return this.applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(ApplicationDeploymentLifecycle deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersionStatus() {
            return this.versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(ApplicationVersionLifecycle versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationArn(String var1);

        public Builder applicationId(String var1);

        public Builder applicationVersion(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(ApplicationDeploymentLifecycle var1);

        public Builder description(String var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder environmentId(String var1);

        public Builder lastStartTime(Instant var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationLifecycle var1);

        public Builder versionStatus(String var1);

        public Builder versionStatus(ApplicationVersionLifecycle var1);
    }
}

