/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.ApplicationVersionSummary;
import software.amazon.awssdk.services.m2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse;

public class ListApplicationVersionsIterable
implements SdkIterable<ListApplicationVersionsResponse> {
    private final M2Client client;
    private final ListApplicationVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationVersionsIterable(M2Client client, ListApplicationVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationVersionsResponseFetcher();
    }

    public Iterator<ListApplicationVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationVersionSummary> applicationVersions() {
        Function<ListApplicationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationVersions() != null) {
                return response.applicationVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationVersionsResponseFetcher
    implements SyncPageFetcher<ListApplicationVersionsResponse> {
        private ListApplicationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationVersionsResponse nextPage(ListApplicationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationVersionsIterable.this.client.listApplicationVersions(ListApplicationVersionsIterable.this.firstRequest);
            }
            return ListApplicationVersionsIterable.this.client.listApplicationVersions((ListApplicationVersionsRequest)((Object)ListApplicationVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

