/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.EngineType;
import software.amazon.awssdk.services.m2.model.EnvironmentLifecycle;
import software.amazon.awssdk.services.m2.model.HighAvailabilityConfig;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.services.m2.model.PendingMaintenance;
import software.amazon.awssdk.services.m2.model.StorageConfiguration;
import software.amazon.awssdk.services.m2.model.StorageConfigurationListCopier;
import software.amazon.awssdk.services.m2.model.String50ListCopier;
import software.amazon.awssdk.services.m2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnvironmentResponse
extends M2Response
implements ToCopyableBuilder<Builder, GetEnvironmentResponse> {
    private static final SdkField<Integer> ACTUAL_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("actualCapacity").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::actualCapacity)).setter(GetEnvironmentResponse.setter(Builder::actualCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualCapacity").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::creationTime)).setter(GetEnvironmentResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::description)).setter(GetEnvironmentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineType").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::engineTypeAsString)).setter(GetEnvironmentResponse.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::engineVersion)).setter(GetEnvironmentResponse.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::environmentArn)).setter(GetEnvironmentResponse.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::environmentId)).setter(GetEnvironmentResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<HighAvailabilityConfig> HIGH_AVAILABILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("highAvailabilityConfig").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::highAvailabilityConfig)).setter(GetEnvironmentResponse.setter(Builder::highAvailabilityConfig)).constructor(HighAvailabilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highAvailabilityConfig").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::instanceType)).setter(GetEnvironmentResponse.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::kmsKeyId)).setter(GetEnvironmentResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadBalancerArn").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::loadBalancerArn)).setter(GetEnvironmentResponse.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::name)).setter(GetEnvironmentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PendingMaintenance> PENDING_MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pendingMaintenance").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::pendingMaintenance)).setter(GetEnvironmentResponse.setter(Builder::pendingMaintenance)).constructor(PendingMaintenance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingMaintenance").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredMaintenanceWindow").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::preferredMaintenanceWindow)).setter(GetEnvironmentResponse.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::publiclyAccessible)).setter(GetEnvironmentResponse.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::securityGroupIds)).setter(GetEnvironmentResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::statusAsString)).setter(GetEnvironmentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::statusReason)).setter(GetEnvironmentResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<List<StorageConfiguration>> STORAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storageConfigurations").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::storageConfigurations)).setter(GetEnvironmentResponse.setter(Builder::storageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::subnetIds)).setter(GetEnvironmentResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::tags)).setter(GetEnvironmentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::vpcId)).setter(GetEnvironmentResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_CAPACITY_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, ENVIRONMENT_ARN_FIELD, ENVIRONMENT_ID_FIELD, HIGH_AVAILABILITY_CONFIG_FIELD, INSTANCE_TYPE_FIELD, KMS_KEY_ID_FIELD, LOAD_BALANCER_ARN_FIELD, NAME_FIELD, PENDING_MAINTENANCE_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUP_IDS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STORAGE_CONFIGURATIONS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actualCapacity", ACTUAL_CAPACITY_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("engineType", ENGINE_TYPE_FIELD);
            this.put("engineVersion", ENGINE_VERSION_FIELD);
            this.put("environmentArn", ENVIRONMENT_ARN_FIELD);
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("highAvailabilityConfig", HIGH_AVAILABILITY_CONFIG_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
            this.put("loadBalancerArn", LOAD_BALANCER_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("pendingMaintenance", PENDING_MAINTENANCE_FIELD);
            this.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
            this.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
            this.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("storageConfigurations", STORAGE_CONFIGURATIONS_FIELD);
            this.put("subnetIds", SUBNET_IDS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("vpcId", VPC_ID_FIELD);
        }
    });
    private final Integer actualCapacity;
    private final Instant creationTime;
    private final String description;
    private final String engineType;
    private final String engineVersion;
    private final String environmentArn;
    private final String environmentId;
    private final HighAvailabilityConfig highAvailabilityConfig;
    private final String instanceType;
    private final String kmsKeyId;
    private final String loadBalancerArn;
    private final String name;
    private final PendingMaintenance pendingMaintenance;
    private final String preferredMaintenanceWindow;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroupIds;
    private final String status;
    private final String statusReason;
    private final List<StorageConfiguration> storageConfigurations;
    private final List<String> subnetIds;
    private final Map<String, String> tags;
    private final String vpcId;

    private GetEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.actualCapacity = builder.actualCapacity;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.environmentArn = builder.environmentArn;
        this.environmentId = builder.environmentId;
        this.highAvailabilityConfig = builder.highAvailabilityConfig;
        this.instanceType = builder.instanceType;
        this.kmsKeyId = builder.kmsKeyId;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.name = builder.name;
        this.pendingMaintenance = builder.pendingMaintenance;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.storageConfigurations = builder.storageConfigurations;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public final Integer actualCapacity() {
        return this.actualCapacity;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final HighAvailabilityConfig highAvailabilityConfig() {
        return this.highAvailabilityConfig;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final String name() {
        return this.name;
    }

    public final PendingMaintenance pendingMaintenance() {
        return this.pendingMaintenance;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final EnvironmentLifecycle status() {
        return EnvironmentLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasStorageConfigurations() {
        return this.storageConfigurations != null && !(this.storageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<StorageConfiguration> storageConfigurations() {
        return this.storageConfigurations;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actualCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.highAvailabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingMaintenance());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConfigurations() ? this.storageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentResponse)) {
            return false;
        }
        GetEnvironmentResponse other = (GetEnvironmentResponse)((Object)obj);
        return Objects.equals(this.actualCapacity(), other.actualCapacity()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.highAvailabilityConfig(), other.highAvailabilityConfig()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pendingMaintenance(), other.pendingMaintenance()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasStorageConfigurations() == other.hasStorageConfigurations() && Objects.equals(this.storageConfigurations(), other.storageConfigurations()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnvironmentResponse").add("ActualCapacity", (Object)this.actualCapacity()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("EngineType", (Object)this.engineTypeAsString()).add("EngineVersion", (Object)this.engineVersion()).add("EnvironmentArn", (Object)this.environmentArn()).add("EnvironmentId", (Object)this.environmentId()).add("HighAvailabilityConfig", (Object)this.highAvailabilityConfig()).add("InstanceType", (Object)this.instanceType()).add("KmsKeyId", (Object)this.kmsKeyId()).add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("Name", (Object)this.name()).add("PendingMaintenance", (Object)this.pendingMaintenance()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StorageConfigurations", this.hasStorageConfigurations() ? this.storageConfigurations() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actualCapacity": {
                return Optional.ofNullable(clazz.cast(this.actualCapacity()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "highAvailabilityConfig": {
                return Optional.ofNullable(clazz.cast(this.highAvailabilityConfig()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "loadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "pendingMaintenance": {
                return Optional.ofNullable(clazz.cast(this.pendingMaintenance()));
            }
            case "preferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "storageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.storageConfigurations()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentResponse, T> g) {
        return obj -> g.apply((GetEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private Integer actualCapacity;
        private Instant creationTime;
        private String description;
        private String engineType;
        private String engineVersion;
        private String environmentArn;
        private String environmentId;
        private HighAvailabilityConfig highAvailabilityConfig;
        private String instanceType;
        private String kmsKeyId;
        private String loadBalancerArn;
        private String name;
        private PendingMaintenance pendingMaintenance;
        private String preferredMaintenanceWindow;
        private Boolean publiclyAccessible;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;
        private List<StorageConfiguration> storageConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentResponse model) {
            super(model);
            this.actualCapacity(model.actualCapacity);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.environmentArn(model.environmentArn);
            this.environmentId(model.environmentId);
            this.highAvailabilityConfig(model.highAvailabilityConfig);
            this.instanceType(model.instanceType);
            this.kmsKeyId(model.kmsKeyId);
            this.loadBalancerArn(model.loadBalancerArn);
            this.name(model.name);
            this.pendingMaintenance(model.pendingMaintenance);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroupIds(model.securityGroupIds);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.storageConfigurations(model.storageConfigurations);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final Integer getActualCapacity() {
            return this.actualCapacity;
        }

        public final void setActualCapacity(Integer actualCapacity) {
            this.actualCapacity = actualCapacity;
        }

        @Override
        public final Builder actualCapacity(Integer actualCapacity) {
            this.actualCapacity = actualCapacity;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final HighAvailabilityConfig.Builder getHighAvailabilityConfig() {
            return this.highAvailabilityConfig != null ? this.highAvailabilityConfig.toBuilder() : null;
        }

        public final void setHighAvailabilityConfig(HighAvailabilityConfig.BuilderImpl highAvailabilityConfig) {
            this.highAvailabilityConfig = highAvailabilityConfig != null ? highAvailabilityConfig.build() : null;
        }

        @Override
        public final Builder highAvailabilityConfig(HighAvailabilityConfig highAvailabilityConfig) {
            this.highAvailabilityConfig = highAvailabilityConfig;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PendingMaintenance.Builder getPendingMaintenance() {
            return this.pendingMaintenance != null ? this.pendingMaintenance.toBuilder() : null;
        }

        public final void setPendingMaintenance(PendingMaintenance.BuilderImpl pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance != null ? pendingMaintenance.build() : null;
        }

        @Override
        public final Builder pendingMaintenance(PendingMaintenance pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = String50ListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = String50ListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final List<StorageConfiguration.Builder> getStorageConfigurations() {
            List<StorageConfiguration.Builder> result = StorageConfigurationListCopier.copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(Collection<StorageConfiguration.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationListCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<StorageConfiguration> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationListCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(StorageConfiguration ... storageConfigurations) {
            this.storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(Consumer<StorageConfiguration.Builder> ... storageConfigurations) {
            this.storageConfigurations(Stream.of(storageConfigurations).map(c -> (StorageConfiguration)((StorageConfiguration.Builder)StorageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = String50ListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = String50ListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public GetEnvironmentResponse build() {
            return new GetEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnvironmentResponse> {
        public Builder actualCapacity(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder environmentArn(String var1);

        public Builder environmentId(String var1);

        public Builder highAvailabilityConfig(HighAvailabilityConfig var1);

        default public Builder highAvailabilityConfig(Consumer<HighAvailabilityConfig.Builder> highAvailabilityConfig) {
            return this.highAvailabilityConfig((HighAvailabilityConfig)((HighAvailabilityConfig.Builder)HighAvailabilityConfig.builder().applyMutation(highAvailabilityConfig)).build());
        }

        public Builder instanceType(String var1);

        public Builder kmsKeyId(String var1);

        public Builder loadBalancerArn(String var1);

        public Builder name(String var1);

        public Builder pendingMaintenance(PendingMaintenance var1);

        default public Builder pendingMaintenance(Consumer<PendingMaintenance.Builder> pendingMaintenance) {
            return this.pendingMaintenance((PendingMaintenance)((PendingMaintenance.Builder)PendingMaintenance.builder().applyMutation(pendingMaintenance)).build());
        }

        public Builder preferredMaintenanceWindow(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder status(String var1);

        public Builder status(EnvironmentLifecycle var1);

        public Builder statusReason(String var1);

        public Builder storageConfigurations(Collection<StorageConfiguration> var1);

        public Builder storageConfigurations(StorageConfiguration ... var1);

        public Builder storageConfigurations(Consumer<StorageConfiguration.Builder> ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcId(String var1);
    }
}

