/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.DatasetOrgAttributes;
import software.amazon.awssdk.services.m2.model.RecordLength;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSet> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetName").getter(DataSet.getter(DataSet::datasetName)).setter(DataSet.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()}).build();
    private static final SdkField<DatasetOrgAttributes> DATASET_ORG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetOrg").getter(DataSet.getter(DataSet::datasetOrg)).setter(DataSet.setter(Builder::datasetOrg)).constructor(DatasetOrgAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetOrg").build()}).build();
    private static final SdkField<RecordLength> RECORD_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordLength").getter(DataSet.getter(DataSet::recordLength)).setter(DataSet.setter(Builder::recordLength)).constructor(RecordLength::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordLength").build()}).build();
    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relativePath").getter(DataSet.getter(DataSet::relativePath)).setter(DataSet.setter(Builder::relativePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativePath").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(DataSet.getter(DataSet::storageType)).setter(DataSet.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, DATASET_ORG_FIELD, RECORD_LENGTH_FIELD, RELATIVE_PATH_FIELD, STORAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String datasetName;
    private final DatasetOrgAttributes datasetOrg;
    private final RecordLength recordLength;
    private final String relativePath;
    private final String storageType;

    private DataSet(BuilderImpl builder) {
        this.datasetName = builder.datasetName;
        this.datasetOrg = builder.datasetOrg;
        this.recordLength = builder.recordLength;
        this.relativePath = builder.relativePath;
        this.storageType = builder.storageType;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final DatasetOrgAttributes datasetOrg() {
        return this.datasetOrg;
    }

    public final RecordLength recordLength() {
        return this.recordLength;
    }

    public final String relativePath() {
        return this.relativePath;
    }

    public final String storageType() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetOrg());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)obj;
        return Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetOrg(), other.datasetOrg()) && Objects.equals(this.recordLength(), other.recordLength()) && Objects.equals(this.relativePath(), other.relativePath()) && Objects.equals(this.storageType(), other.storageType());
    }

    public final String toString() {
        return ToString.builder((String)"DataSet").add("DatasetName", (Object)this.datasetName()).add("DatasetOrg", (Object)this.datasetOrg()).add("RecordLength", (Object)this.recordLength()).add("RelativePath", (Object)this.relativePath()).add("StorageType", (Object)this.storageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "datasetOrg": {
                return Optional.ofNullable(clazz.cast(this.datasetOrg()));
            }
            case "recordLength": {
                return Optional.ofNullable(clazz.cast(this.recordLength()));
            }
            case "relativePath": {
                return Optional.ofNullable(clazz.cast(this.relativePath()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSet, T> g) {
        return obj -> g.apply((DataSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetName;
        private DatasetOrgAttributes datasetOrg;
        private RecordLength recordLength;
        private String relativePath;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSet model) {
            this.datasetName(model.datasetName);
            this.datasetOrg(model.datasetOrg);
            this.recordLength(model.recordLength);
            this.relativePath(model.relativePath);
            this.storageType(model.storageType);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final DatasetOrgAttributes.Builder getDatasetOrg() {
            return this.datasetOrg != null ? this.datasetOrg.toBuilder() : null;
        }

        public final void setDatasetOrg(DatasetOrgAttributes.BuilderImpl datasetOrg) {
            this.datasetOrg = datasetOrg != null ? datasetOrg.build() : null;
        }

        @Override
        public final Builder datasetOrg(DatasetOrgAttributes datasetOrg) {
            this.datasetOrg = datasetOrg;
            return this;
        }

        public final RecordLength.Builder getRecordLength() {
            return this.recordLength != null ? this.recordLength.toBuilder() : null;
        }

        public final void setRecordLength(RecordLength.BuilderImpl recordLength) {
            this.recordLength = recordLength != null ? recordLength.build() : null;
        }

        @Override
        public final Builder recordLength(RecordLength recordLength) {
            this.recordLength = recordLength;
            return this;
        }

        public final String getRelativePath() {
            return this.relativePath;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public DataSet build() {
            return new DataSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSet> {
        public Builder datasetName(String var1);

        public Builder datasetOrg(DatasetOrgAttributes var1);

        default public Builder datasetOrg(Consumer<DatasetOrgAttributes.Builder> datasetOrg) {
            return this.datasetOrg((DatasetOrgAttributes)((DatasetOrgAttributes.Builder)DatasetOrgAttributes.builder().applyMutation(datasetOrg)).build());
        }

        public Builder recordLength(RecordLength var1);

        default public Builder recordLength(Consumer<RecordLength.Builder> recordLength) {
            return this.recordLength((RecordLength)((RecordLength.Builder)RecordLength.builder().applyMutation(recordLength)).build());
        }

        public Builder relativePath(String var1);

        public Builder storageType(String var1);
    }
}

