/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.ApplicationLifecycle;
import software.amazon.awssdk.services.m2.model.ApplicationVersionSummary;
import software.amazon.awssdk.services.m2.model.ArnListCopier;
import software.amazon.awssdk.services.m2.model.DeployedVersionSummary;
import software.amazon.awssdk.services.m2.model.EngineType;
import software.amazon.awssdk.services.m2.model.LogGroupSummariesCopier;
import software.amazon.awssdk.services.m2.model.LogGroupSummary;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.services.m2.model.PortListCopier;
import software.amazon.awssdk.services.m2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationResponse
extends M2Response
implements ToCopyableBuilder<Builder, GetApplicationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationArn)).setter(GetApplicationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationId)).setter(GetApplicationResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetApplicationResponse.getter(GetApplicationResponse::creationTime)).setter(GetApplicationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<DeployedVersionSummary> DEPLOYED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deployedVersion").getter(GetApplicationResponse.getter(GetApplicationResponse::deployedVersion)).setter(GetApplicationResponse.setter(Builder::deployedVersion)).constructor(DeployedVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployedVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetApplicationResponse.getter(GetApplicationResponse::description)).setter(GetApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineType").getter(GetApplicationResponse.getter(GetApplicationResponse::engineTypeAsString)).setter(GetApplicationResponse.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(GetApplicationResponse.getter(GetApplicationResponse::environmentId)).setter(GetApplicationResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(GetApplicationResponse.getter(GetApplicationResponse::kmsKeyId)).setter(GetApplicationResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartTime").getter(GetApplicationResponse.getter(GetApplicationResponse::lastStartTime)).setter(GetApplicationResponse.setter(Builder::lastStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()}).build();
    private static final SdkField<ApplicationVersionSummary> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersion").getter(GetApplicationResponse.getter(GetApplicationResponse::latestVersion)).setter(GetApplicationResponse.setter(Builder::latestVersion)).constructor(ApplicationVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final SdkField<List<String>> LISTENER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listenerArns").getter(GetApplicationResponse.getter(GetApplicationResponse::listenerArns)).setter(GetApplicationResponse.setter(Builder::listenerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> LISTENER_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listenerPorts").getter(GetApplicationResponse.getter(GetApplicationResponse::listenerPorts)).setter(GetApplicationResponse.setter(Builder::listenerPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOAD_BALANCER_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadBalancerDnsName").getter(GetApplicationResponse.getter(GetApplicationResponse::loadBalancerDnsName)).setter(GetApplicationResponse.setter(Builder::loadBalancerDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerDnsName").build()}).build();
    private static final SdkField<List<LogGroupSummary>> LOG_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroups").getter(GetApplicationResponse.getter(GetApplicationResponse::logGroups)).setter(GetApplicationResponse.setter(Builder::logGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetApplicationResponse.getter(GetApplicationResponse::name)).setter(GetApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetApplicationResponse.getter(GetApplicationResponse::roleArn)).setter(GetApplicationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetApplicationResponse.getter(GetApplicationResponse::statusAsString)).setter(GetApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetApplicationResponse.getter(GetApplicationResponse::statusReason)).setter(GetApplicationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetApplicationResponse.getter(GetApplicationResponse::tags)).setter(GetApplicationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetGroupArns").getter(GetApplicationResponse.getter(GetApplicationResponse::targetGroupArns)).setter(GetApplicationResponse.setter(Builder::targetGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_ID_FIELD, CREATION_TIME_FIELD, DEPLOYED_VERSION_FIELD, DESCRIPTION_FIELD, ENGINE_TYPE_FIELD, ENVIRONMENT_ID_FIELD, KMS_KEY_ID_FIELD, LAST_START_TIME_FIELD, LATEST_VERSION_FIELD, LISTENER_ARNS_FIELD, LISTENER_PORTS_FIELD, LOAD_BALANCER_DNS_NAME_FIELD, LOG_GROUPS_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD, TARGET_GROUP_ARNS_FIELD));
    private final String applicationArn;
    private final String applicationId;
    private final Instant creationTime;
    private final DeployedVersionSummary deployedVersion;
    private final String description;
    private final String engineType;
    private final String environmentId;
    private final String kmsKeyId;
    private final Instant lastStartTime;
    private final ApplicationVersionSummary latestVersion;
    private final List<String> listenerArns;
    private final List<Integer> listenerPorts;
    private final String loadBalancerDnsName;
    private final List<LogGroupSummary> logGroups;
    private final String name;
    private final String roleArn;
    private final String status;
    private final String statusReason;
    private final Map<String, String> tags;
    private final List<String> targetGroupArns;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.deployedVersion = builder.deployedVersion;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.environmentId = builder.environmentId;
        this.kmsKeyId = builder.kmsKeyId;
        this.lastStartTime = builder.lastStartTime;
        this.latestVersion = builder.latestVersion;
        this.listenerArns = builder.listenerArns;
        this.listenerPorts = builder.listenerPorts;
        this.loadBalancerDnsName = builder.loadBalancerDnsName;
        this.logGroups = builder.logGroups;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.targetGroupArns = builder.targetGroupArns;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final DeployedVersionSummary deployedVersion() {
        return this.deployedVersion;
    }

    public final String description() {
        return this.description;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Instant lastStartTime() {
        return this.lastStartTime;
    }

    public final ApplicationVersionSummary latestVersion() {
        return this.latestVersion;
    }

    public final boolean hasListenerArns() {
        return this.listenerArns != null && !(this.listenerArns instanceof SdkAutoConstructList);
    }

    public final List<String> listenerArns() {
        return this.listenerArns;
    }

    public final boolean hasListenerPorts() {
        return this.listenerPorts != null && !(this.listenerPorts instanceof SdkAutoConstructList);
    }

    public final List<Integer> listenerPorts() {
        return this.listenerPorts;
    }

    public final String loadBalancerDnsName() {
        return this.loadBalancerDnsName;
    }

    public final boolean hasLogGroups() {
        return this.logGroups != null && !(this.logGroups instanceof SdkAutoConstructList);
    }

    public final List<LogGroupSummary> logGroups() {
        return this.logGroups;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ApplicationLifecycle status() {
        return ApplicationLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasTargetGroupArns() {
        return this.targetGroupArns != null && !(this.targetGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> targetGroupArns() {
        return this.targetGroupArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerArns() ? this.listenerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerPorts() ? this.listenerPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroups() ? this.logGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroupArns() ? this.targetGroupArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deployedVersion(), other.deployedVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.latestVersion(), other.latestVersion()) && this.hasListenerArns() == other.hasListenerArns() && Objects.equals(this.listenerArns(), other.listenerArns()) && this.hasListenerPorts() == other.hasListenerPorts() && Objects.equals(this.listenerPorts(), other.listenerPorts()) && Objects.equals(this.loadBalancerDnsName(), other.loadBalancerDnsName()) && this.hasLogGroups() == other.hasLogGroups() && Objects.equals(this.logGroups(), other.logGroups()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTargetGroupArns() == other.hasTargetGroupArns() && Objects.equals(this.targetGroupArns(), other.targetGroupArns());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationResponse").add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationId", (Object)this.applicationId()).add("CreationTime", (Object)this.creationTime()).add("DeployedVersion", (Object)this.deployedVersion()).add("Description", (Object)this.description()).add("EngineType", (Object)this.engineTypeAsString()).add("EnvironmentId", (Object)this.environmentId()).add("KmsKeyId", (Object)this.kmsKeyId()).add("LastStartTime", (Object)this.lastStartTime()).add("LatestVersion", (Object)this.latestVersion()).add("ListenerArns", this.hasListenerArns() ? this.listenerArns() : null).add("ListenerPorts", this.hasListenerPorts() ? this.listenerPorts() : null).add("LoadBalancerDnsName", (Object)this.loadBalancerDnsName()).add("LogGroups", this.hasLogGroups() ? this.logGroups() : null).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetGroupArns", this.hasTargetGroupArns() ? this.targetGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "deployedVersion": {
                return Optional.ofNullable(clazz.cast(this.deployedVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "lastStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastStartTime()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "listenerArns": {
                return Optional.ofNullable(clazz.cast(this.listenerArns()));
            }
            case "listenerPorts": {
                return Optional.ofNullable(clazz.cast(this.listenerPorts()));
            }
            case "loadBalancerDnsName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerDnsName()));
            }
            case "logGroups": {
                return Optional.ofNullable(clazz.cast(this.logGroups()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targetGroupArns": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String applicationId;
        private Instant creationTime;
        private DeployedVersionSummary deployedVersion;
        private String description;
        private String engineType;
        private String environmentId;
        private String kmsKeyId;
        private Instant lastStartTime;
        private ApplicationVersionSummary latestVersion;
        private List<String> listenerArns = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> listenerPorts = DefaultSdkAutoConstructList.getInstance();
        private String loadBalancerDnsName;
        private List<LogGroupSummary> logGroups = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String roleArn;
        private String status;
        private String statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> targetGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.applicationId(model.applicationId);
            this.creationTime(model.creationTime);
            this.deployedVersion(model.deployedVersion);
            this.description(model.description);
            this.engineType(model.engineType);
            this.environmentId(model.environmentId);
            this.kmsKeyId(model.kmsKeyId);
            this.lastStartTime(model.lastStartTime);
            this.latestVersion(model.latestVersion);
            this.listenerArns(model.listenerArns);
            this.listenerPorts(model.listenerPorts);
            this.loadBalancerDnsName(model.loadBalancerDnsName);
            this.logGroups(model.logGroups);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
            this.targetGroupArns(model.targetGroupArns);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final DeployedVersionSummary.Builder getDeployedVersion() {
            return this.deployedVersion != null ? this.deployedVersion.toBuilder() : null;
        }

        public final void setDeployedVersion(DeployedVersionSummary.BuilderImpl deployedVersion) {
            this.deployedVersion = deployedVersion != null ? deployedVersion.build() : null;
        }

        @Override
        public final Builder deployedVersion(DeployedVersionSummary deployedVersion) {
            this.deployedVersion = deployedVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final ApplicationVersionSummary.Builder getLatestVersion() {
            return this.latestVersion != null ? this.latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(ApplicationVersionSummary.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(ApplicationVersionSummary latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Collection<String> getListenerArns() {
            if (this.listenerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listenerArns;
        }

        public final void setListenerArns(Collection<String> listenerArns) {
            this.listenerArns = ArnListCopier.copy(listenerArns);
        }

        @Override
        public final Builder listenerArns(Collection<String> listenerArns) {
            this.listenerArns = ArnListCopier.copy(listenerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerArns(String ... listenerArns) {
            this.listenerArns(Arrays.asList(listenerArns));
            return this;
        }

        public final Collection<Integer> getListenerPorts() {
            if (this.listenerPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listenerPorts;
        }

        public final void setListenerPorts(Collection<Integer> listenerPorts) {
            this.listenerPorts = PortListCopier.copy(listenerPorts);
        }

        @Override
        public final Builder listenerPorts(Collection<Integer> listenerPorts) {
            this.listenerPorts = PortListCopier.copy(listenerPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPorts(Integer ... listenerPorts) {
            this.listenerPorts(Arrays.asList(listenerPorts));
            return this;
        }

        public final String getLoadBalancerDnsName() {
            return this.loadBalancerDnsName;
        }

        public final void setLoadBalancerDnsName(String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
        }

        @Override
        public final Builder loadBalancerDnsName(String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
            return this;
        }

        public final List<LogGroupSummary.Builder> getLogGroups() {
            List<LogGroupSummary.Builder> result = LogGroupSummariesCopier.copyToBuilder(this.logGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroups(Collection<LogGroupSummary.BuilderImpl> logGroups) {
            this.logGroups = LogGroupSummariesCopier.copyFromBuilder(logGroups);
        }

        @Override
        public final Builder logGroups(Collection<LogGroupSummary> logGroups) {
            this.logGroups = LogGroupSummariesCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroupSummary ... logGroups) {
            this.logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<LogGroupSummary.Builder> ... logGroups) {
            this.logGroups(Stream.of(logGroups).map(c -> (LogGroupSummary)((LogGroupSummary.Builder)LogGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getTargetGroupArns() {
            if (this.targetGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetGroupArns;
        }

        public final void setTargetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = ArnListCopier.copy(targetGroupArns);
        }

        @Override
        public final Builder targetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = ArnListCopier.copy(targetGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupArns(String ... targetGroupArns) {
            this.targetGroupArns(Arrays.asList(targetGroupArns));
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationResponse> {
        public Builder applicationArn(String var1);

        public Builder applicationId(String var1);

        public Builder creationTime(Instant var1);

        public Builder deployedVersion(DeployedVersionSummary var1);

        default public Builder deployedVersion(Consumer<DeployedVersionSummary.Builder> deployedVersion) {
            return this.deployedVersion((DeployedVersionSummary)((DeployedVersionSummary.Builder)DeployedVersionSummary.builder().applyMutation(deployedVersion)).build());
        }

        public Builder description(String var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder environmentId(String var1);

        public Builder kmsKeyId(String var1);

        public Builder lastStartTime(Instant var1);

        public Builder latestVersion(ApplicationVersionSummary var1);

        default public Builder latestVersion(Consumer<ApplicationVersionSummary.Builder> latestVersion) {
            return this.latestVersion((ApplicationVersionSummary)((ApplicationVersionSummary.Builder)ApplicationVersionSummary.builder().applyMutation(latestVersion)).build());
        }

        public Builder listenerArns(Collection<String> var1);

        public Builder listenerArns(String ... var1);

        public Builder listenerPorts(Collection<Integer> var1);

        public Builder listenerPorts(Integer ... var1);

        public Builder loadBalancerDnsName(String var1);

        public Builder logGroups(Collection<LogGroupSummary> var1);

        public Builder logGroups(LogGroupSummary ... var1);

        public Builder logGroups(Consumer<LogGroupSummary.Builder> ... var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationLifecycle var1);

        public Builder statusReason(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetGroupArns(Collection<String> var1);

        public Builder targetGroupArns(String ... var1);
    }
}

