/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary;
import software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest;
import software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse;

public class ListBatchJobExecutionsIterable
implements SdkIterable<ListBatchJobExecutionsResponse> {
    private final M2Client client;
    private final ListBatchJobExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBatchJobExecutionsIterable(M2Client client, ListBatchJobExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBatchJobExecutionsResponseFetcher();
    }

    public Iterator<ListBatchJobExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BatchJobExecutionSummary> batchJobExecutions() {
        Function<ListBatchJobExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchJobExecutions() != null) {
                return response.batchJobExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBatchJobExecutionsResponseFetcher
    implements SyncPageFetcher<ListBatchJobExecutionsResponse> {
        private ListBatchJobExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchJobExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBatchJobExecutionsResponse nextPage(ListBatchJobExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchJobExecutionsIterable.this.client.listBatchJobExecutions(ListBatchJobExecutionsIterable.this.firstRequest);
            }
            return ListBatchJobExecutionsIterable.this.client.listBatchJobExecutions((ListBatchJobExecutionsRequest)((Object)ListBatchJobExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

