/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FsxStorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FsxStorageConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemId").getter(FsxStorageConfiguration.getter(FsxStorageConfiguration::fileSystemId)).setter(FsxStorageConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file-system-id").build()}).build();
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mountPoint").getter(FsxStorageConfiguration.getter(FsxStorageConfiguration::mountPoint)).setter(FsxStorageConfiguration.setter(Builder::mountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mount-point").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, MOUNT_POINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String mountPoint;

    private FsxStorageConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.mountPoint = builder.mountPoint;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String mountPoint() {
        return this.mountPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxStorageConfiguration)) {
            return false;
        }
        FsxStorageConfiguration other = (FsxStorageConfiguration)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.mountPoint(), other.mountPoint());
    }

    public final String toString() {
        return ToString.builder((String)"FsxStorageConfiguration").add("FileSystemId", (Object)this.fileSystemId()).add("MountPoint", (Object)this.mountPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "mountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FsxStorageConfiguration, T> g) {
        return obj -> g.apply((FsxStorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String mountPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxStorageConfiguration model) {
            this.fileSystemId(model.fileSystemId);
            this.mountPoint(model.mountPoint);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public FsxStorageConfiguration build() {
            return new FsxStorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FsxStorageConfiguration> {
        public Builder fileSystemId(String var1);

        public Builder mountPoint(String var1);
    }
}

