/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.GdgDetailAttributes;
import software.amazon.awssdk.services.m2.model.VsamDetailAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetDetailOrgAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetDetailOrgAttributes> {
    private static final SdkField<GdgDetailAttributes> GDG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gdg").getter(DatasetDetailOrgAttributes.getter(DatasetDetailOrgAttributes::gdg)).setter(DatasetDetailOrgAttributes.setter(Builder::gdg)).constructor(GdgDetailAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gdg").build()}).build();
    private static final SdkField<VsamDetailAttributes> VSAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vsam").getter(DatasetDetailOrgAttributes.getter(DatasetDetailOrgAttributes::vsam)).setter(DatasetDetailOrgAttributes.setter(Builder::vsam)).constructor(VsamDetailAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vsam").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GDG_FIELD, VSAM_FIELD));
    private static final long serialVersionUID = 1L;
    private final GdgDetailAttributes gdg;
    private final VsamDetailAttributes vsam;
    private final Type type;

    private DatasetDetailOrgAttributes(BuilderImpl builder) {
        this.gdg = builder.gdg;
        this.vsam = builder.vsam;
        this.type = builder.type;
    }

    public final GdgDetailAttributes gdg() {
        return this.gdg;
    }

    public final VsamDetailAttributes vsam() {
        return this.vsam;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gdg());
        hashCode = 31 * hashCode + Objects.hashCode(this.vsam());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDetailOrgAttributes)) {
            return false;
        }
        DatasetDetailOrgAttributes other = (DatasetDetailOrgAttributes)obj;
        return Objects.equals(this.gdg(), other.gdg()) && Objects.equals(this.vsam(), other.vsam());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetDetailOrgAttributes").add("Gdg", (Object)this.gdg()).add("Vsam", (Object)this.vsam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gdg": {
                return Optional.ofNullable(clazz.cast(this.gdg()));
            }
            case "vsam": {
                return Optional.ofNullable(clazz.cast(this.vsam()));
            }
        }
        return Optional.empty();
    }

    public static DatasetDetailOrgAttributes fromGdg(GdgDetailAttributes gdg) {
        return (DatasetDetailOrgAttributes)DatasetDetailOrgAttributes.builder().gdg(gdg).build();
    }

    public static DatasetDetailOrgAttributes fromGdg(Consumer<GdgDetailAttributes.Builder> gdg) {
        GdgDetailAttributes.Builder builder = GdgDetailAttributes.builder();
        gdg.accept(builder);
        return DatasetDetailOrgAttributes.fromGdg((GdgDetailAttributes)builder.build());
    }

    public static DatasetDetailOrgAttributes fromVsam(VsamDetailAttributes vsam) {
        return (DatasetDetailOrgAttributes)DatasetDetailOrgAttributes.builder().vsam(vsam).build();
    }

    public static DatasetDetailOrgAttributes fromVsam(Consumer<VsamDetailAttributes.Builder> vsam) {
        VsamDetailAttributes.Builder builder = VsamDetailAttributes.builder();
        vsam.accept(builder);
        return DatasetDetailOrgAttributes.fromVsam((VsamDetailAttributes)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetDetailOrgAttributes, T> g) {
        return obj -> g.apply((DatasetDetailOrgAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GDG,
        VSAM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GdgDetailAttributes gdg;
        private VsamDetailAttributes vsam;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDetailOrgAttributes model) {
            this.gdg(model.gdg);
            this.vsam(model.vsam);
        }

        public final GdgDetailAttributes.Builder getGdg() {
            return this.gdg != null ? this.gdg.toBuilder() : null;
        }

        public final void setGdg(GdgDetailAttributes.BuilderImpl gdg) {
            GdgDetailAttributes oldValue = this.gdg;
            this.gdg = gdg != null ? gdg.build() : null;
            this.handleUnionValueChange(Type.GDG, oldValue, this.gdg);
        }

        @Override
        public final Builder gdg(GdgDetailAttributes gdg) {
            GdgDetailAttributes oldValue = this.gdg;
            this.gdg = gdg;
            this.handleUnionValueChange(Type.GDG, oldValue, this.gdg);
            return this;
        }

        public final VsamDetailAttributes.Builder getVsam() {
            return this.vsam != null ? this.vsam.toBuilder() : null;
        }

        public final void setVsam(VsamDetailAttributes.BuilderImpl vsam) {
            VsamDetailAttributes oldValue = this.vsam;
            this.vsam = vsam != null ? vsam.build() : null;
            this.handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
        }

        @Override
        public final Builder vsam(VsamDetailAttributes vsam) {
            VsamDetailAttributes oldValue = this.vsam;
            this.vsam = vsam;
            this.handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
            return this;
        }

        public DatasetDetailOrgAttributes build() {
            return new DatasetDetailOrgAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetDetailOrgAttributes> {
        public Builder gdg(GdgDetailAttributes var1);

        default public Builder gdg(Consumer<GdgDetailAttributes.Builder> gdg) {
            return this.gdg((GdgDetailAttributes)((GdgDetailAttributes.Builder)GdgDetailAttributes.builder().applyMutation(gdg)).build());
        }

        public Builder vsam(VsamDetailAttributes var1);

        default public Builder vsam(Consumer<VsamDetailAttributes.Builder> vsam) {
            return this.vsam((VsamDetailAttributes)((VsamDetailAttributes.Builder)VsamDetailAttributes.builder().applyMutation(vsam)).build());
        }
    }
}

