/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationVersionLifecycle {
    CREATING("Creating"),
    AVAILABLE("Available"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationVersionLifecycle> VALUE_MAP;
    private final String value;

    private ApplicationVersionLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationVersionLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationVersionLifecycle> knownValues() {
        EnumSet<ApplicationVersionLifecycle> knownValues = EnumSet.allOf(ApplicationVersionLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationVersionLifecycle.class, ApplicationVersionLifecycle::toString);
    }
}

