/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.MaintenanceSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingMaintenance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingMaintenance> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(PendingMaintenance.getter(PendingMaintenance::engineVersion)).setter(PendingMaintenance.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<MaintenanceSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(PendingMaintenance.getter(PendingMaintenance::schedule)).setter(PendingMaintenance.setter(Builder::schedule)).constructor(MaintenanceSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD, SCHEDULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engineVersion;
    private final MaintenanceSchedule schedule;

    private PendingMaintenance(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.schedule = builder.schedule;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final MaintenanceSchedule schedule() {
        return this.schedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingMaintenance)) {
            return false;
        }
        PendingMaintenance other = (PendingMaintenance)obj;
        return Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.schedule(), other.schedule());
    }

    public final String toString() {
        return ToString.builder((String)"PendingMaintenance").add("EngineVersion", (Object)this.engineVersion()).add("Schedule", (Object)this.schedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingMaintenance, T> g) {
        return obj -> g.apply((PendingMaintenance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineVersion;
        private MaintenanceSchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingMaintenance model) {
            this.engineVersion(model.engineVersion);
            this.schedule(model.schedule);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final MaintenanceSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(MaintenanceSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(MaintenanceSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public PendingMaintenance build() {
            return new PendingMaintenance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingMaintenance> {
        public Builder engineVersion(String var1);

        public Builder schedule(MaintenanceSchedule var1);

        default public Builder schedule(Consumer<MaintenanceSchedule.Builder> schedule) {
            return this.schedule((MaintenanceSchedule)((MaintenanceSchedule.Builder)MaintenanceSchedule.builder().applyMutation(schedule)).build());
        }
    }
}

