/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.model.DeploymentSummary;
import software.amazon.awssdk.services.m2.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.m2.model.ListDeploymentsResponse;

public class ListDeploymentsIterable
implements SdkIterable<ListDeploymentsResponse> {
    private final M2Client client;
    private final ListDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentsIterable(M2Client client, ListDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentsResponseFetcher();
    }

    public Iterator<ListDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeploymentSummary> deployments() {
        Function<ListDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deployments() != null) {
                return response.deployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeploymentsResponseFetcher
    implements SyncPageFetcher<ListDeploymentsResponse> {
        private ListDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentsResponse nextPage(ListDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentsIterable.this.client.listDeployments(ListDeploymentsIterable.this.firstRequest);
            }
            return ListDeploymentsIterable.this.client.listDeployments((ListDeploymentsRequest)((Object)ListDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

