/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.DatasetImageStats;
import software.amazon.awssdk.services.lookoutvision.model.DatasetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetDescription> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(DatasetDescription.getter(DatasetDescription::projectName)).setter(DatasetDescription.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(DatasetDescription.getter(DatasetDescription::datasetType)).setter(DatasetDescription.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(DatasetDescription.getter(DatasetDescription::creationTimestamp)).setter(DatasetDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(DatasetDescription.getter(DatasetDescription::lastUpdatedTimestamp)).setter(DatasetDescription.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DatasetDescription.getter(DatasetDescription::statusAsString)).setter(DatasetDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DatasetDescription.getter(DatasetDescription::statusMessage)).setter(DatasetDescription.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<DatasetImageStats> IMAGE_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageStats").getter(DatasetDescription.getter(DatasetDescription::imageStats)).setter(DatasetDescription.setter(Builder::imageStats)).constructor(DatasetImageStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageStats").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, DATASET_TYPE_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, IMAGE_STATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectName;
    private final String datasetType;
    private final Instant creationTimestamp;
    private final Instant lastUpdatedTimestamp;
    private final String status;
    private final String statusMessage;
    private final DatasetImageStats imageStats;

    private DatasetDescription(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.imageStats = builder.imageStats;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String datasetType() {
        return this.datasetType;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final DatasetImageStats imageStats() {
        return this.imageStats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageStats());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDescription)) {
            return false;
        }
        DatasetDescription other = (DatasetDescription)obj;
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.datasetType(), other.datasetType()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.imageStats(), other.imageStats());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetDescription").add("ProjectName", (Object)this.projectName()).add("DatasetType", (Object)this.datasetType()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ImageStats", (Object)this.imageStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetType()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ImageStats": {
                return Optional.ofNullable(clazz.cast(this.imageStats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("DatasetType", DATASET_TYPE_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ImageStats", IMAGE_STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetDescription, T> g) {
        return obj -> g.apply((DatasetDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String datasetType;
        private Instant creationTimestamp;
        private Instant lastUpdatedTimestamp;
        private String status;
        private String statusMessage;
        private DatasetImageStats imageStats;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDescription model) {
            this.projectName(model.projectName);
            this.datasetType(model.datasetType);
            this.creationTimestamp(model.creationTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.imageStats(model.imageStats);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final DatasetImageStats.Builder getImageStats() {
            return this.imageStats != null ? this.imageStats.toBuilder() : null;
        }

        public final void setImageStats(DatasetImageStats.BuilderImpl imageStats) {
            this.imageStats = imageStats != null ? imageStats.build() : null;
        }

        @Override
        public final Builder imageStats(DatasetImageStats imageStats) {
            this.imageStats = imageStats;
            return this;
        }

        public DatasetDescription build() {
            return new DatasetDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetDescription> {
        public Builder projectName(String var1);

        public Builder datasetType(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder statusMessage(String var1);

        public Builder imageStats(DatasetImageStats var1);

        default public Builder imageStats(Consumer<DatasetImageStats.Builder> imageStats) {
            return this.imageStats((DatasetImageStats)((DatasetImageStats.Builder)DatasetImageStats.builder().applyMutation(imageStats)).build());
        }
    }
}

