/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.ModelPerformance;
import software.amazon.awssdk.services.lookoutvision.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelMetadata> {
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(ModelMetadata.getter(ModelMetadata::creationTimestamp)).setter(ModelMetadata.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(ModelMetadata.getter(ModelMetadata::modelVersion)).setter(ModelMetadata.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(ModelMetadata.getter(ModelMetadata::modelArn)).setter(ModelMetadata.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModelMetadata.getter(ModelMetadata::description)).setter(ModelMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelMetadata.getter(ModelMetadata::statusAsString)).setter(ModelMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ModelMetadata.getter(ModelMetadata::statusMessage)).setter(ModelMetadata.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<ModelPerformance> PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Performance").getter(ModelMetadata.getter(ModelMetadata::performance)).setter(ModelMetadata.setter(Builder::performance)).constructor(ModelPerformance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Performance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIMESTAMP_FIELD, MODEL_VERSION_FIELD, MODEL_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PERFORMANCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationTimestamp;
    private final String modelVersion;
    private final String modelArn;
    private final String description;
    private final String status;
    private final String statusMessage;
    private final ModelPerformance performance;

    private ModelMetadata(BuilderImpl builder) {
        this.creationTimestamp = builder.creationTimestamp;
        this.modelVersion = builder.modelVersion;
        this.modelArn = builder.modelArn;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.performance = builder.performance;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String description() {
        return this.description;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ModelPerformance performance() {
        return this.performance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.performance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelMetadata)) {
            return false;
        }
        ModelMetadata other = (ModelMetadata)obj;
        return Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.performance(), other.performance());
    }

    public final String toString() {
        return ToString.builder((String)"ModelMetadata").add("CreationTimestamp", (Object)this.creationTimestamp()).add("ModelVersion", (Object)this.modelVersion()).add("ModelArn", (Object)this.modelArn()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Performance", (Object)this.performance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Performance": {
                return Optional.ofNullable(clazz.cast(this.performance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelMetadata, T> g) {
        return obj -> g.apply((ModelMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTimestamp;
        private String modelVersion;
        private String modelArn;
        private String description;
        private String status;
        private String statusMessage;
        private ModelPerformance performance;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelMetadata model) {
            this.creationTimestamp(model.creationTimestamp);
            this.modelVersion(model.modelVersion);
            this.modelArn(model.modelArn);
            this.description(model.description);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.performance(model.performance);
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        @Transient
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        @Transient
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ModelPerformance.Builder getPerformance() {
            return this.performance != null ? this.performance.toBuilder() : null;
        }

        public final void setPerformance(ModelPerformance.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        @Transient
        public final Builder performance(ModelPerformance performance) {
            this.performance = performance;
            return this;
        }

        public ModelMetadata build() {
            return new ModelMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelMetadata> {
        public Builder creationTimestamp(Instant var1);

        public Builder modelVersion(String var1);

        public Builder modelArn(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder statusMessage(String var1);

        public Builder performance(ModelPerformance var1);

        default public Builder performance(Consumer<ModelPerformance.Builder> performance) {
            return this.performance((ModelPerformance)((ModelPerformance.Builder)ModelPerformance.builder().applyMutation(performance)).build());
        }
    }
}

