/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatasetEntriesRequest
extends LookoutVisionRequest
implements ToCopyableBuilder<Builder, UpdateDatasetEntriesRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(UpdateDatasetEntriesRequest.getter(UpdateDatasetEntriesRequest::projectName)).setter(UpdateDatasetEntriesRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(UpdateDatasetEntriesRequest.getter(UpdateDatasetEntriesRequest::datasetType)).setter(UpdateDatasetEntriesRequest.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetType").build()}).build();
    private static final SdkField<SdkBytes> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Changes").getter(UpdateDatasetEntriesRequest.getter(UpdateDatasetEntriesRequest::changes)).setter(UpdateDatasetEntriesRequest.setter(Builder::changes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateDatasetEntriesRequest.getter(UpdateDatasetEntriesRequest::clientToken)).setter(UpdateDatasetEntriesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, DATASET_TYPE_FIELD, CHANGES_FIELD, CLIENT_TOKEN_FIELD));
    private final String projectName;
    private final String datasetType;
    private final SdkBytes changes;
    private final String clientToken;

    private UpdateDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
        this.changes = builder.changes;
        this.clientToken = builder.clientToken;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String datasetType() {
        return this.datasetType;
    }

    public final SdkBytes changes() {
        return this.changes;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.changes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetEntriesRequest)) {
            return false;
        }
        UpdateDatasetEntriesRequest other = (UpdateDatasetEntriesRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.datasetType(), other.datasetType()) && Objects.equals(this.changes(), other.changes()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatasetEntriesRequest").add("ProjectName", (Object)this.projectName()).add("DatasetType", (Object)this.datasetType()).add("Changes", (Object)this.changes()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetType()));
            }
            case "Changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetEntriesRequest, T> g) {
        return obj -> g.apply((UpdateDatasetEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutVisionRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String datasetType;
        private SdkBytes changes;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetEntriesRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.datasetType(model.datasetType);
            this.changes(model.changes);
            this.clientToken(model.clientToken);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        @Transient
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final ByteBuffer getChanges() {
            return this.changes == null ? null : this.changes.asByteBuffer();
        }

        public final void setChanges(ByteBuffer changes) {
            this.changes(changes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)changes));
        }

        @Override
        @Transient
        public final Builder changes(SdkBytes changes) {
            this.changes = changes;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetEntriesRequest build() {
            return new UpdateDatasetEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutVisionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatasetEntriesRequest> {
        public Builder projectName(String var1);

        public Builder datasetType(String var1);

        public Builder changes(SdkBytes var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

