/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionResponse;
import software.amazon.awssdk.services.lookoutvision.model.ModelMetadata;
import software.amazon.awssdk.services.lookoutvision.model.ModelMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelsResponse
extends LookoutVisionResponse
implements ToCopyableBuilder<Builder, ListModelsResponse> {
    private static final SdkField<List<ModelMetadata>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Models").getter(ListModelsResponse.getter(ListModelsResponse::models)).setter(ListModelsResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelsResponse.getter(ListModelsResponse::nextToken)).setter(ListModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODELS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ModelMetadata> models;
    private final String nextToken;

    private ListModelsResponse(BuilderImpl builder) {
        super(builder);
        this.models = builder.models;
        this.nextToken = builder.nextToken;
    }

    public boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public List<ModelMetadata> models() {
        return this.models;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsResponse)) {
            return false;
        }
        ListModelsResponse other = (ListModelsResponse)((Object)obj);
        return this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListModelsResponse").add("Models", this.hasModels() ? this.models() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelsResponse, T> g) {
        return obj -> g.apply((ListModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutVisionResponse.BuilderImpl
    implements Builder {
        private List<ModelMetadata> models = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsResponse model) {
            super(model);
            this.models(model.models);
            this.nextToken(model.nextToken);
        }

        public final Collection<ModelMetadata.Builder> getModels() {
            if (this.models instanceof SdkAutoConstructList) {
                return null;
            }
            return this.models != null ? (Collection)this.models.stream().map(ModelMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<ModelMetadata> models) {
            this.models = ModelMetadataListCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(ModelMetadata ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<ModelMetadata.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (ModelMetadata)((ModelMetadata.Builder)ModelMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<ModelMetadata.BuilderImpl> models) {
            this.models = ModelMetadataListCopier.copyFromBuilder(models);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListModelsResponse build() {
            return new ListModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutVisionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelsResponse> {
        public Builder models(Collection<ModelMetadata> var1);

        public Builder models(ModelMetadata ... var1);

        public Builder models(Consumer<ModelMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

