/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemizedMetricStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemizedMetricStats> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(ItemizedMetricStats.getter(ItemizedMetricStats::metricName)).setter(ItemizedMetricStats.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<Integer> OCCURRENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OccurrenceCount").getter(ItemizedMetricStats.getter(ItemizedMetricStats::occurrenceCount)).setter(ItemizedMetricStats.setter(Builder::occurrenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, OCCURRENCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("OccurrenceCount", OCCURRENCE_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final Integer occurrenceCount;

    private ItemizedMetricStats(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.occurrenceCount = builder.occurrenceCount;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final Integer occurrenceCount() {
        return this.occurrenceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemizedMetricStats)) {
            return false;
        }
        ItemizedMetricStats other = (ItemizedMetricStats)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.occurrenceCount(), other.occurrenceCount());
    }

    public final String toString() {
        return ToString.builder((String)"ItemizedMetricStats").add("MetricName", (Object)this.metricName()).add("OccurrenceCount", (Object)this.occurrenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "OccurrenceCount": {
                return Optional.ofNullable(clazz.cast(this.occurrenceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ItemizedMetricStats, T> g) {
        return obj -> g.apply((ItemizedMetricStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private Integer occurrenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemizedMetricStats model) {
            this.metricName(model.metricName);
            this.occurrenceCount(model.occurrenceCount);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Integer getOccurrenceCount() {
            return this.occurrenceCount;
        }

        public final void setOccurrenceCount(Integer occurrenceCount) {
            this.occurrenceCount = occurrenceCount;
        }

        @Override
        public final Builder occurrenceCount(Integer occurrenceCount) {
            this.occurrenceCount = occurrenceCount;
            return this;
        }

        public ItemizedMetricStats build() {
            return new ItemizedMetricStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemizedMetricStats> {
        public Builder metricName(String var1);

        public Builder occurrenceCount(Integer var1);
    }
}

