/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.BinaryListAttributeValueCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.NumberListAttributeValueCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.StringListAttributeValueCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S").getter(AttributeValue.getter(AttributeValue::s)).setter(AttributeValue.setter(Builder::s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()}).build();
    private static final SdkField<String> N_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("N").getter(AttributeValue.getter(AttributeValue::n)).setter(AttributeValue.setter(Builder::n)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()}).build();
    private static final SdkField<String> B_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("B").getter(AttributeValue.getter(AttributeValue::b)).setter(AttributeValue.setter(Builder::b)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()}).build();
    private static final SdkField<List<String>> SS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SS").getter(AttributeValue.getter(AttributeValue::ss)).setter(AttributeValue.setter(Builder::ss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NS").getter(AttributeValue.getter(AttributeValue::ns)).setter(AttributeValue.setter(Builder::ns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BS").getter(AttributeValue.getter(AttributeValue::bs)).setter(AttributeValue.setter(Builder::bs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, B_FIELD, SS_FIELD, NS_FIELD, BS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S", S_FIELD);
            this.put("N", N_FIELD);
            this.put("B", B_FIELD);
            this.put("SS", SS_FIELD);
            this.put("NS", NS_FIELD);
            this.put("BS", BS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s;
    private final String n;
    private final String b;
    private final List<String> ss;
    private final List<String> ns;
    private final List<String> bs;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
    }

    public final String s() {
        return this.s;
    }

    public final String n() {
        return this.n;
    }

    public final String b() {
        return this.b;
    }

    public final boolean hasSs() {
        return this.ss != null && !(this.ss instanceof SdkAutoConstructList);
    }

    public final List<String> ss() {
        return this.ss;
    }

    public final boolean hasNs() {
        return this.ns != null && !(this.ns instanceof SdkAutoConstructList);
    }

    public final List<String> ns() {
        return this.ns;
    }

    public final boolean hasBs() {
        return this.bs != null && !(this.bs instanceof SdkAutoConstructList);
    }

    public final List<String> bs() {
        return this.bs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.b());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSs() ? this.ss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNs() ? this.ns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBs() ? this.bs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.b(), other.b()) && this.hasSs() == other.hasSs() && Objects.equals(this.ss(), other.ss()) && this.hasNs() == other.hasNs() && Objects.equals(this.ns(), other.ns()) && this.hasBs() == other.hasBs() && Objects.equals(this.bs(), other.bs());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeValue").add("S", (Object)this.s()).add("N", (Object)this.n()).add("B", (Object)this.b()).add("SS", this.hasSs() ? this.ss() : null).add("NS", this.hasNs() ? this.ns() : null).add("BS", this.hasBs() ? this.bs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.ofNullable(clazz.cast(this.s()));
            }
            case "N": {
                return Optional.ofNullable(clazz.cast(this.n()));
            }
            case "B": {
                return Optional.ofNullable(clazz.cast(this.b()));
            }
            case "SS": {
                return Optional.ofNullable(clazz.cast(this.ss()));
            }
            case "NS": {
                return Optional.ofNullable(clazz.cast(this.ns()));
            }
            case "BS": {
                return Optional.ofNullable(clazz.cast(this.bs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private String n;
        private String b;
        private List<String> ss = DefaultSdkAutoConstructList.getInstance();
        private List<String> ns = DefaultSdkAutoConstructList.getInstance();
        private List<String> bs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.s(model.s);
            this.n(model.n);
            this.b(model.b);
            this.ss(model.ss);
            this.ns(model.ns);
            this.bs(model.bs);
        }

        public final String getS() {
            return this.s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final String getN() {
            return this.n;
        }

        public final void setN(String n) {
            this.n = n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final String getB() {
            return this.b;
        }

        public final void setB(String b) {
            this.b = b;
        }

        @Override
        public final Builder b(String b) {
            this.b = b;
            return this;
        }

        public final Collection<String> getSs() {
            if (this.ss instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ss;
        }

        public final void setSs(Collection<String> ss) {
            this.ss = StringListAttributeValueCopier.copy(ss);
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringListAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String ... ss) {
            this.ss(Arrays.asList(ss));
            return this;
        }

        public final Collection<String> getNs() {
            if (this.ns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ns;
        }

        public final void setNs(Collection<String> ns) {
            this.ns = NumberListAttributeValueCopier.copy(ns);
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberListAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String ... ns) {
            this.ns(Arrays.asList(ns));
            return this;
        }

        public final Collection<String> getBs() {
            if (this.bs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bs;
        }

        public final void setBs(Collection<String> bs) {
            this.bs = BinaryListAttributeValueCopier.copy(bs);
        }

        @Override
        public final Builder bs(Collection<String> bs) {
            this.bs = BinaryListAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(String ... bs) {
            this.bs(Arrays.asList(bs));
            return this;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(String var1);

        public Builder b(String var1);

        public Builder ss(Collection<String> var1);

        public Builder ss(String ... var1);

        public Builder ns(Collection<String> var1);

        public Builder ns(String ... var1);

        public Builder bs(Collection<String> var1);

        public Builder bs(String ... var1);
    }
}

