/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.FilterOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionValue").getter(Filter.getter(Filter::dimensionValue)).setter(Filter.setter(Builder::dimensionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()}).build();
    private static final SdkField<String> FILTER_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterOperation").getter(Filter.getter(Filter::filterOperationAsString)).setter(Filter.setter(Builder::filterOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUE_FIELD, FILTER_OPERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DimensionValue", DIMENSION_VALUE_FIELD);
            this.put("FilterOperation", FILTER_OPERATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dimensionValue;
    private final String filterOperation;

    private Filter(BuilderImpl builder) {
        this.dimensionValue = builder.dimensionValue;
        this.filterOperation = builder.filterOperation;
    }

    public final String dimensionValue() {
        return this.dimensionValue;
    }

    public final FilterOperation filterOperation() {
        return FilterOperation.fromValue(this.filterOperation);
    }

    public final String filterOperationAsString() {
        return this.filterOperation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterOperationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.dimensionValue(), other.dimensionValue()) && Objects.equals(this.filterOperationAsString(), other.filterOperationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("DimensionValue", (Object)this.dimensionValue()).add("FilterOperation", (Object)this.filterOperationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionValue": {
                return Optional.ofNullable(clazz.cast(this.dimensionValue()));
            }
            case "FilterOperation": {
                return Optional.ofNullable(clazz.cast(this.filterOperationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionValue;
        private String filterOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.dimensionValue(model.dimensionValue);
            this.filterOperation(model.filterOperation);
        }

        public final String getDimensionValue() {
            return this.dimensionValue;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        public final String getFilterOperation() {
            return this.filterOperation;
        }

        public final void setFilterOperation(String filterOperation) {
            this.filterOperation = filterOperation;
        }

        @Override
        public final Builder filterOperation(String filterOperation) {
            this.filterOperation = filterOperation;
            return this;
        }

        @Override
        public final Builder filterOperation(FilterOperation filterOperation) {
            this.filterOperation(filterOperation == null ? null : filterOperation.toString());
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder dimensionValue(String var1);

        public Builder filterOperation(String var1);

        public Builder filterOperation(FilterOperation var1);
    }
}

