/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDataQualityMetric;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDataQualityMetricListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetectorDataQualityMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetectorDataQualityMetric> {
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(AnomalyDetectorDataQualityMetric.getter(AnomalyDetectorDataQualityMetric::startTimestamp)).setter(AnomalyDetectorDataQualityMetric.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<List<MetricSetDataQualityMetric>> METRIC_SET_DATA_QUALITY_METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricSetDataQualityMetricList").getter(AnomalyDetectorDataQualityMetric.getter(AnomalyDetectorDataQualityMetric::metricSetDataQualityMetricList)).setter(AnomalyDetectorDataQualityMetric.setter(Builder::metricSetDataQualityMetricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDataQualityMetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricSetDataQualityMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIMESTAMP_FIELD, METRIC_SET_DATA_QUALITY_METRIC_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StartTimestamp", START_TIMESTAMP_FIELD);
            this.put("MetricSetDataQualityMetricList", METRIC_SET_DATA_QUALITY_METRIC_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant startTimestamp;
    private final List<MetricSetDataQualityMetric> metricSetDataQualityMetricList;

    private AnomalyDetectorDataQualityMetric(BuilderImpl builder) {
        this.startTimestamp = builder.startTimestamp;
        this.metricSetDataQualityMetricList = builder.metricSetDataQualityMetricList;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final boolean hasMetricSetDataQualityMetricList() {
        return this.metricSetDataQualityMetricList != null && !(this.metricSetDataQualityMetricList instanceof SdkAutoConstructList);
    }

    public final List<MetricSetDataQualityMetric> metricSetDataQualityMetricList() {
        return this.metricSetDataQualityMetricList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricSetDataQualityMetricList() ? this.metricSetDataQualityMetricList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorDataQualityMetric)) {
            return false;
        }
        AnomalyDetectorDataQualityMetric other = (AnomalyDetectorDataQualityMetric)obj;
        return Objects.equals(this.startTimestamp(), other.startTimestamp()) && this.hasMetricSetDataQualityMetricList() == other.hasMetricSetDataQualityMetricList() && Objects.equals(this.metricSetDataQualityMetricList(), other.metricSetDataQualityMetricList());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetectorDataQualityMetric").add("StartTimestamp", (Object)this.startTimestamp()).add("MetricSetDataQualityMetricList", this.hasMetricSetDataQualityMetricList() ? this.metricSetDataQualityMetricList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "MetricSetDataQualityMetricList": {
                return Optional.ofNullable(clazz.cast(this.metricSetDataQualityMetricList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorDataQualityMetric, T> g) {
        return obj -> g.apply((AnomalyDetectorDataQualityMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTimestamp;
        private List<MetricSetDataQualityMetric> metricSetDataQualityMetricList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorDataQualityMetric model) {
            this.startTimestamp(model.startTimestamp);
            this.metricSetDataQualityMetricList(model.metricSetDataQualityMetricList);
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final List<MetricSetDataQualityMetric.Builder> getMetricSetDataQualityMetricList() {
            List<MetricSetDataQualityMetric.Builder> result = MetricSetDataQualityMetricListCopier.copyToBuilder(this.metricSetDataQualityMetricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricSetDataQualityMetricList(Collection<MetricSetDataQualityMetric.BuilderImpl> metricSetDataQualityMetricList) {
            this.metricSetDataQualityMetricList = MetricSetDataQualityMetricListCopier.copyFromBuilder(metricSetDataQualityMetricList);
        }

        @Override
        public final Builder metricSetDataQualityMetricList(Collection<MetricSetDataQualityMetric> metricSetDataQualityMetricList) {
            this.metricSetDataQualityMetricList = MetricSetDataQualityMetricListCopier.copy(metricSetDataQualityMetricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetDataQualityMetricList(MetricSetDataQualityMetric ... metricSetDataQualityMetricList) {
            this.metricSetDataQualityMetricList(Arrays.asList(metricSetDataQualityMetricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetDataQualityMetricList(Consumer<MetricSetDataQualityMetric.Builder> ... metricSetDataQualityMetricList) {
            this.metricSetDataQualityMetricList(Stream.of(metricSetDataQualityMetricList).map(c -> (MetricSetDataQualityMetric)((MetricSetDataQualityMetric.Builder)MetricSetDataQualityMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnomalyDetectorDataQualityMetric build() {
            return new AnomalyDetectorDataQualityMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetectorDataQualityMetric> {
        public Builder startTimestamp(Instant var1);

        public Builder metricSetDataQualityMetricList(Collection<MetricSetDataQualityMetric> var1);

        public Builder metricSetDataQualityMetricList(MetricSetDataQualityMetric ... var1);

        public Builder metricSetDataQualityMetricList(Consumer<MetricSetDataQualityMetric.Builder> ... var1);
    }
}

