/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CloudWatchConfig.getter(CloudWatchConfig::roleArn)).setter(CloudWatchConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<BackTestConfiguration> BACK_TEST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackTestConfiguration").getter(CloudWatchConfig.getter(CloudWatchConfig::backTestConfiguration)).setter(CloudWatchConfig.setter(Builder::backTestConfiguration)).constructor(BackTestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackTestConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, BACK_TEST_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final BackTestConfiguration backTestConfiguration;

    private CloudWatchConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.backTestConfiguration = builder.backTestConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final BackTestConfiguration backTestConfiguration() {
        return this.backTestConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backTestConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchConfig)) {
            return false;
        }
        CloudWatchConfig other = (CloudWatchConfig)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.backTestConfiguration(), other.backTestConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchConfig").add("RoleArn", (Object)this.roleArn()).add("BackTestConfiguration", (Object)this.backTestConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "BackTestConfiguration": {
                return Optional.ofNullable(clazz.cast(this.backTestConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchConfig, T> g) {
        return obj -> g.apply((CloudWatchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private BackTestConfiguration backTestConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchConfig model) {
            this.roleArn(model.roleArn);
            this.backTestConfiguration(model.backTestConfiguration);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final BackTestConfiguration.Builder getBackTestConfiguration() {
            return this.backTestConfiguration != null ? this.backTestConfiguration.toBuilder() : null;
        }

        public final void setBackTestConfiguration(BackTestConfiguration.BuilderImpl backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration != null ? backTestConfiguration.build() : null;
        }

        @Override
        public final Builder backTestConfiguration(BackTestConfiguration backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration;
            return this;
        }

        public CloudWatchConfig build() {
            return new CloudWatchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchConfig> {
        public Builder roleArn(String var1);

        public Builder backTestConfiguration(BackTestConfiguration var1);

        default public Builder backTestConfiguration(Consumer<BackTestConfiguration.Builder> backTestConfiguration) {
            return this.backTestConfiguration((BackTestConfiguration)((BackTestConfiguration.Builder)BackTestConfiguration.builder().applyMutation(backTestConfiguration)).build());
        }
    }
}

