/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse;

public class ListAnomalyGroupTimeSeriesIterable
implements SdkIterable<ListAnomalyGroupTimeSeriesResponse> {
    private final LookoutMetricsClient client;
    private final ListAnomalyGroupTimeSeriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomalyGroupTimeSeriesIterable(LookoutMetricsClient client, ListAnomalyGroupTimeSeriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnomalyGroupTimeSeriesResponseFetcher();
    }

    public Iterator<ListAnomalyGroupTimeSeriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAnomalyGroupTimeSeriesResponseFetcher
    implements SyncPageFetcher<ListAnomalyGroupTimeSeriesResponse> {
        private ListAnomalyGroupTimeSeriesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalyGroupTimeSeriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomalyGroupTimeSeriesResponse nextPage(ListAnomalyGroupTimeSeriesResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalyGroupTimeSeriesIterable.this.client.listAnomalyGroupTimeSeries(ListAnomalyGroupTimeSeriesIterable.this.firstRequest);
            }
            return ListAnomalyGroupTimeSeriesIterable.this.client.listAnomalyGroupTimeSeries((ListAnomalyGroupTimeSeriesRequest)((Object)ListAnomalyGroupTimeSeriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

