/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorStatus;
import software.amazon.awssdk.services.lookoutmetrics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetectorSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetectorSummary> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::anomalyDetectorArn)).setter(AnomalyDetectorSummary.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorName").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::anomalyDetectorName)).setter(AnomalyDetectorSummary.setter(Builder::anomalyDetectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorName").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorDescription").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::anomalyDetectorDescription)).setter(AnomalyDetectorSummary.setter(Builder::anomalyDetectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::creationTime)).setter(AnomalyDetectorSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::lastModificationTime)).setter(AnomalyDetectorSummary.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::statusAsString)).setter(AnomalyDetectorSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(AnomalyDetectorSummary.getter(AnomalyDetectorSummary::tags)).setter(AnomalyDetectorSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, ANOMALY_DETECTOR_NAME_FIELD, ANOMALY_DETECTOR_DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String anomalyDetectorArn;
    private final String anomalyDetectorName;
    private final String anomalyDetectorDescription;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final String status;
    private final Map<String, String> tags;

    private AnomalyDetectorSummary(BuilderImpl builder) {
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyDetectorName = builder.anomalyDetectorName;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String anomalyDetectorName() {
        return this.anomalyDetectorName;
    }

    public final String anomalyDetectorDescription() {
        return this.anomalyDetectorDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final AnomalyDetectorStatus status() {
        return AnomalyDetectorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorSummary)) {
            return false;
        }
        AnomalyDetectorSummary other = (AnomalyDetectorSummary)obj;
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.anomalyDetectorName(), other.anomalyDetectorName()) && Objects.equals(this.anomalyDetectorDescription(), other.anomalyDetectorDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetectorSummary").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AnomalyDetectorName", (Object)this.anomalyDetectorName()).add("AnomalyDetectorDescription", (Object)this.anomalyDetectorDescription()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AnomalyDetectorName": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorName()));
            }
            case "AnomalyDetectorDescription": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorSummary, T> g) {
        return obj -> g.apply((AnomalyDetectorSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String anomalyDetectorName;
        private String anomalyDetectorDescription;
        private Instant creationTime;
        private Instant lastModificationTime;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorSummary model) {
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.anomalyDetectorName(model.anomalyDetectorName);
            this.anomalyDetectorDescription(model.anomalyDetectorDescription);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAnomalyDetectorName() {
            return this.anomalyDetectorName;
        }

        public final void setAnomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
        }

        @Override
        public final Builder anomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
            return this;
        }

        public final String getAnomalyDetectorDescription() {
            return this.anomalyDetectorDescription;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        @Override
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyDetectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public AnomalyDetectorSummary build() {
            return new AnomalyDetectorSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetectorSummary> {
        public Builder anomalyDetectorArn(String var1);

        public Builder anomalyDetectorName(String var1);

        public Builder anomalyDetectorDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AnomalyDetectorStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

