/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lookoutmetrics.DefaultLookoutMetricsAsyncClient;
import software.amazon.awssdk.services.lookoutmetrics.DefaultLookoutMetricsBaseClientBuilder;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsAsyncClient;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsAsyncClientBuilder;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutmetrics.endpoints.LookoutMetricsEndpointProvider;

@SdkInternalApi
final class DefaultLookoutMetricsAsyncClientBuilder
extends DefaultLookoutMetricsBaseClientBuilder<LookoutMetricsAsyncClientBuilder, LookoutMetricsAsyncClient>
implements LookoutMetricsAsyncClientBuilder {
    DefaultLookoutMetricsAsyncClientBuilder() {
    }

    @Override
    public DefaultLookoutMetricsAsyncClientBuilder endpointProvider(LookoutMetricsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LookoutMetricsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLookoutMetricsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LookoutMetricsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLookoutMetricsAsyncClient client = new DefaultLookoutMetricsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LookoutMetricsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LookoutMetricsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

