/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyGroupTimeSeries;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFeedbackRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, GetFeedbackRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(GetFeedbackRequest.getter(GetFeedbackRequest::anomalyDetectorArn)).setter(GetFeedbackRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<AnomalyGroupTimeSeries> ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyGroupTimeSeriesFeedback").getter(GetFeedbackRequest.getter(GetFeedbackRequest::anomalyGroupTimeSeriesFeedback)).setter(GetFeedbackRequest.setter(Builder::anomalyGroupTimeSeriesFeedback)).constructor(AnomalyGroupTimeSeries::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupTimeSeriesFeedback").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetFeedbackRequest.getter(GetFeedbackRequest::maxResults)).setter(GetFeedbackRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFeedbackRequest.getter(GetFeedbackRequest::nextToken)).setter(GetFeedbackRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String anomalyDetectorArn;
    private final AnomalyGroupTimeSeries anomalyGroupTimeSeriesFeedback;
    private final Integer maxResults;
    private final String nextToken;

    private GetFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyGroupTimeSeriesFeedback = builder.anomalyGroupTimeSeriesFeedback;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final AnomalyGroupTimeSeries anomalyGroupTimeSeriesFeedback() {
        return this.anomalyGroupTimeSeriesFeedback;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupTimeSeriesFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFeedbackRequest)) {
            return false;
        }
        GetFeedbackRequest other = (GetFeedbackRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.anomalyGroupTimeSeriesFeedback(), other.anomalyGroupTimeSeriesFeedback()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetFeedbackRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AnomalyGroupTimeSeriesFeedback", (Object)this.anomalyGroupTimeSeriesFeedback()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AnomalyGroupTimeSeriesFeedback": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupTimeSeriesFeedback()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFeedbackRequest, T> g) {
        return obj -> g.apply((GetFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private AnomalyGroupTimeSeries anomalyGroupTimeSeriesFeedback;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFeedbackRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.anomalyGroupTimeSeriesFeedback(model.anomalyGroupTimeSeriesFeedback);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final AnomalyGroupTimeSeries.Builder getAnomalyGroupTimeSeriesFeedback() {
            return this.anomalyGroupTimeSeriesFeedback != null ? this.anomalyGroupTimeSeriesFeedback.toBuilder() : null;
        }

        public final void setAnomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeries.BuilderImpl anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = anomalyGroupTimeSeriesFeedback != null ? anomalyGroupTimeSeriesFeedback.build() : null;
        }

        @Override
        @Transient
        public final Builder anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeries anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = anomalyGroupTimeSeriesFeedback;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFeedbackRequest build() {
            return new GetFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFeedbackRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeries var1);

        default public Builder anomalyGroupTimeSeriesFeedback(Consumer<AnomalyGroupTimeSeries.Builder> anomalyGroupTimeSeriesFeedback) {
            return this.anomalyGroupTimeSeriesFeedback((AnomalyGroupTimeSeries)((AnomalyGroupTimeSeries.Builder)AnomalyGroupTimeSeries.builder().applyMutation(anomalyGroupTimeSeriesFeedback)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

