/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.RelationshipType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomalyGroupRelatedMetricsRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, ListAnomalyGroupRelatedMetricsRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(ListAnomalyGroupRelatedMetricsRequest.getter(ListAnomalyGroupRelatedMetricsRequest::anomalyDetectorArn)).setter(ListAnomalyGroupRelatedMetricsRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyGroupId").getter(ListAnomalyGroupRelatedMetricsRequest.getter(ListAnomalyGroupRelatedMetricsRequest::anomalyGroupId)).setter(ListAnomalyGroupRelatedMetricsRequest.setter(Builder::anomalyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()}).build();
    private static final SdkField<String> RELATIONSHIP_TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelationshipTypeFilter").getter(ListAnomalyGroupRelatedMetricsRequest.getter(ListAnomalyGroupRelatedMetricsRequest::relationshipTypeFilterAsString)).setter(ListAnomalyGroupRelatedMetricsRequest.setter(Builder::relationshipTypeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipTypeFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAnomalyGroupRelatedMetricsRequest.getter(ListAnomalyGroupRelatedMetricsRequest::maxResults)).setter(ListAnomalyGroupRelatedMetricsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnomalyGroupRelatedMetricsRequest.getter(ListAnomalyGroupRelatedMetricsRequest::nextToken)).setter(ListAnomalyGroupRelatedMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, ANOMALY_GROUP_ID_FIELD, RELATIONSHIP_TYPE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String anomalyDetectorArn;
    private final String anomalyGroupId;
    private final String relationshipTypeFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListAnomalyGroupRelatedMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.relationshipTypeFilter = builder.relationshipTypeFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String anomalyGroupId() {
        return this.anomalyGroupId;
    }

    public final RelationshipType relationshipTypeFilter() {
        return RelationshipType.fromValue(this.relationshipTypeFilter);
    }

    public final String relationshipTypeFilterAsString() {
        return this.relationshipTypeFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupRelatedMetricsRequest)) {
            return false;
        }
        ListAnomalyGroupRelatedMetricsRequest other = (ListAnomalyGroupRelatedMetricsRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(this.relationshipTypeFilterAsString(), other.relationshipTypeFilterAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomalyGroupRelatedMetricsRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AnomalyGroupId", (Object)this.anomalyGroupId()).add("RelationshipTypeFilter", (Object)this.relationshipTypeFilterAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AnomalyGroupId": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupId()));
            }
            case "RelationshipTypeFilter": {
                return Optional.ofNullable(clazz.cast(this.relationshipTypeFilterAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupRelatedMetricsRequest, T> g) {
        return obj -> g.apply((ListAnomalyGroupRelatedMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String anomalyGroupId;
        private String relationshipTypeFilter;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupRelatedMetricsRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.anomalyGroupId(model.anomalyGroupId);
            this.relationshipTypeFilter(model.relationshipTypeFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAnomalyGroupId() {
            return this.anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        @Transient
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getRelationshipTypeFilter() {
            return this.relationshipTypeFilter;
        }

        public final void setRelationshipTypeFilter(String relationshipTypeFilter) {
            this.relationshipTypeFilter = relationshipTypeFilter;
        }

        @Override
        @Transient
        public final Builder relationshipTypeFilter(String relationshipTypeFilter) {
            this.relationshipTypeFilter = relationshipTypeFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder relationshipTypeFilter(RelationshipType relationshipTypeFilter) {
            this.relationshipTypeFilter(relationshipTypeFilter == null ? null : relationshipTypeFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAnomalyGroupRelatedMetricsRequest build() {
            return new ListAnomalyGroupRelatedMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomalyGroupRelatedMetricsRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder anomalyGroupId(String var1);

        public Builder relationshipTypeFilter(String var1);

        public Builder relationshipTypeFilter(RelationshipType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

