/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AlertType {
    SNS("SNS"),
    LAMBDA("LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AlertType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlertType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AlertType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlertType> knownValues() {
        return Stream.of(AlertType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

