/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Frequency {
    P1_D("P1D"),
    PT1_H("PT1H"),
    PT10_M("PT10M"),
    PT5_M("PT5M"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Frequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Frequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Frequency.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Frequency> knownValues() {
        return Stream.of(Frequency.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

