/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionNameValue;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionNameValueListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeries
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeries> {
    private static final SdkField<String> TIME_SERIES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeSeriesId").getter(TimeSeries.getter(TimeSeries::timeSeriesId)).setter(TimeSeries.setter(Builder::timeSeriesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesId").build()}).build();
    private static final SdkField<List<DimensionNameValue>> DIMENSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionList").getter(TimeSeries.getter(TimeSeries::dimensionList)).setter(TimeSeries.setter(Builder::dimensionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionNameValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> METRIC_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricValueList").getter(TimeSeries.getter(TimeSeries::metricValueList)).setter(TimeSeries.setter(Builder::metricValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_ID_FIELD, DIMENSION_LIST_FIELD, METRIC_VALUE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timeSeriesId;
    private final List<DimensionNameValue> dimensionList;
    private final List<Double> metricValueList;

    private TimeSeries(BuilderImpl builder) {
        this.timeSeriesId = builder.timeSeriesId;
        this.dimensionList = builder.dimensionList;
        this.metricValueList = builder.metricValueList;
    }

    public final String timeSeriesId() {
        return this.timeSeriesId;
    }

    public final boolean hasDimensionList() {
        return this.dimensionList != null && !(this.dimensionList instanceof SdkAutoConstructList);
    }

    public final List<DimensionNameValue> dimensionList() {
        return this.dimensionList;
    }

    public final boolean hasMetricValueList() {
        return this.metricValueList != null && !(this.metricValueList instanceof SdkAutoConstructList);
    }

    public final List<Double> metricValueList() {
        return this.metricValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionList() ? this.dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricValueList() ? this.metricValueList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeries)) {
            return false;
        }
        TimeSeries other = (TimeSeries)obj;
        return Objects.equals(this.timeSeriesId(), other.timeSeriesId()) && this.hasDimensionList() == other.hasDimensionList() && Objects.equals(this.dimensionList(), other.dimensionList()) && this.hasMetricValueList() == other.hasMetricValueList() && Objects.equals(this.metricValueList(), other.metricValueList());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeries").add("TimeSeriesId", (Object)this.timeSeriesId()).add("DimensionList", this.hasDimensionList() ? this.dimensionList() : null).add("MetricValueList", this.hasMetricValueList() ? this.metricValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeSeriesId": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesId()));
            }
            case "DimensionList": {
                return Optional.ofNullable(clazz.cast(this.dimensionList()));
            }
            case "MetricValueList": {
                return Optional.ofNullable(clazz.cast(this.metricValueList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeries, T> g) {
        return obj -> g.apply((TimeSeries)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeSeriesId;
        private List<DimensionNameValue> dimensionList = DefaultSdkAutoConstructList.getInstance();
        private List<Double> metricValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeries model) {
            this.timeSeriesId(model.timeSeriesId);
            this.dimensionList(model.dimensionList);
            this.metricValueList(model.metricValueList);
        }

        public final String getTimeSeriesId() {
            return this.timeSeriesId;
        }

        @Override
        public final Builder timeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
            return this;
        }

        public final void setTimeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
        }

        public final Collection<DimensionNameValue.Builder> getDimensionList() {
            if (this.dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionList != null ? (Collection)this.dimensionList.stream().map(DimensionNameValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensionList(Collection<DimensionNameValue> dimensionList) {
            this.dimensionList = DimensionNameValueListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(DimensionNameValue ... dimensionList) {
            this.dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(Consumer<DimensionNameValue.Builder> ... dimensionList) {
            this.dimensionList(Stream.of(dimensionList).map(c -> (DimensionNameValue)((DimensionNameValue.Builder)DimensionNameValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensionList(Collection<DimensionNameValue.BuilderImpl> dimensionList) {
            this.dimensionList = DimensionNameValueListCopier.copyFromBuilder(dimensionList);
        }

        public final Collection<Double> getMetricValueList() {
            if (this.metricValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricValueList;
        }

        @Override
        public final Builder metricValueList(Collection<Double> metricValueList) {
            this.metricValueList = MetricValueListCopier.copy(metricValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricValueList(Double ... metricValueList) {
            this.metricValueList(Arrays.asList(metricValueList));
            return this;
        }

        public final void setMetricValueList(Collection<Double> metricValueList) {
            this.metricValueList = MetricValueListCopier.copy(metricValueList);
        }

        public TimeSeries build() {
            return new TimeSeries(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeries> {
        public Builder timeSeriesId(String var1);

        public Builder dimensionList(Collection<DimensionNameValue> var1);

        public Builder dimensionList(DimensionNameValue ... var1);

        public Builder dimensionList(Consumer<DimensionNameValue.Builder> ... var1);

        public Builder metricValueList(Collection<Double> var1);

        public Builder metricValueList(Double ... var1);
    }
}

