/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertSummary;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertSummaryListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlertsResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, ListAlertsResponse> {
    private static final SdkField<List<AlertSummary>> ALERT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlertSummaryList").getter(ListAlertsResponse.getter(ListAlertsResponse::alertSummaryList)).setter(ListAlertsResponse.setter(Builder::alertSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlertSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAlertsResponse.getter(ListAlertsResponse::nextToken)).setter(ListAlertsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<AlertSummary> alertSummaryList;
    private final String nextToken;

    private ListAlertsResponse(BuilderImpl builder) {
        super(builder);
        this.alertSummaryList = builder.alertSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlertSummaryList() {
        return this.alertSummaryList != null && !(this.alertSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AlertSummary> alertSummaryList() {
        return this.alertSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlertSummaryList() ? this.alertSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlertsResponse)) {
            return false;
        }
        ListAlertsResponse other = (ListAlertsResponse)((Object)obj);
        return this.hasAlertSummaryList() == other.hasAlertSummaryList() && Objects.equals(this.alertSummaryList(), other.alertSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlertsResponse").add("AlertSummaryList", this.hasAlertSummaryList() ? this.alertSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertSummaryList": {
                return Optional.ofNullable(clazz.cast(this.alertSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAlertsResponse, T> g) {
        return obj -> g.apply((ListAlertsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<AlertSummary> alertSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlertsResponse model) {
            super(model);
            this.alertSummaryList(model.alertSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<AlertSummary.Builder> getAlertSummaryList() {
            if (this.alertSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alertSummaryList != null ? (Collection)this.alertSummaryList.stream().map(AlertSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alertSummaryList(Collection<AlertSummary> alertSummaryList) {
            this.alertSummaryList = AlertSummaryListCopier.copy(alertSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alertSummaryList(AlertSummary ... alertSummaryList) {
            this.alertSummaryList(Arrays.asList(alertSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alertSummaryList(Consumer<AlertSummary.Builder> ... alertSummaryList) {
            this.alertSummaryList(Stream.of(alertSummaryList).map(c -> (AlertSummary)((AlertSummary.Builder)AlertSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlertSummaryList(Collection<AlertSummary.BuilderImpl> alertSummaryList) {
            this.alertSummaryList = AlertSummaryListCopier.copyFromBuilder(alertSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAlertsResponse build() {
            return new ListAlertsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlertsResponse> {
        public Builder alertSummaryList(Collection<AlertSummary> var1);

        public Builder alertSummaryList(AlertSummary ... var1);

        public Builder alertSummaryList(Consumer<AlertSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

