/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelPromoteMode;
import software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRetrainingSchedulerResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeRetrainingSchedulerResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::modelName)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::modelArn)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Instant> RETRAINING_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RetrainingStartDate").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::retrainingStartDate)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::retrainingStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingStartDate").build()}).build();
    private static final SdkField<String> RETRAINING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrainingFrequency").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::retrainingFrequency)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::retrainingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingFrequency").build()}).build();
    private static final SdkField<String> LOOKBACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackWindow").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::lookbackWindow)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::lookbackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::statusAsString)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PROMOTE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromoteMode").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::promoteModeAsString)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::promoteMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromoteMode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::createdAt)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeRetrainingSchedulerResponse.getter(DescribeRetrainingSchedulerResponse::updatedAt)).setter(DescribeRetrainingSchedulerResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, RETRAINING_START_DATE_FIELD, RETRAINING_FREQUENCY_FIELD, LOOKBACK_WINDOW_FIELD, STATUS_FIELD, PROMOTE_MODE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRetrainingSchedulerResponse.memberNameToFieldInitializer();
    private final String modelName;
    private final String modelArn;
    private final Instant retrainingStartDate;
    private final String retrainingFrequency;
    private final String lookbackWindow;
    private final String status;
    private final String promoteMode;
    private final Instant createdAt;
    private final Instant updatedAt;

    private DescribeRetrainingSchedulerResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.retrainingStartDate = builder.retrainingStartDate;
        this.retrainingFrequency = builder.retrainingFrequency;
        this.lookbackWindow = builder.lookbackWindow;
        this.status = builder.status;
        this.promoteMode = builder.promoteMode;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Instant retrainingStartDate() {
        return this.retrainingStartDate;
    }

    public final String retrainingFrequency() {
        return this.retrainingFrequency;
    }

    public final String lookbackWindow() {
        return this.lookbackWindow;
    }

    public final RetrainingSchedulerStatus status() {
        return RetrainingSchedulerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelPromoteMode promoteMode() {
        return ModelPromoteMode.fromValue(this.promoteMode);
    }

    public final String promoteModeAsString() {
        return this.promoteMode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promoteModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetrainingSchedulerResponse)) {
            return false;
        }
        DescribeRetrainingSchedulerResponse other = (DescribeRetrainingSchedulerResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.retrainingStartDate(), other.retrainingStartDate()) && Objects.equals(this.retrainingFrequency(), other.retrainingFrequency()) && Objects.equals(this.lookbackWindow(), other.lookbackWindow()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.promoteModeAsString(), other.promoteModeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRetrainingSchedulerResponse").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("RetrainingStartDate", (Object)this.retrainingStartDate()).add("RetrainingFrequency", (Object)this.retrainingFrequency()).add("LookbackWindow", (Object)this.lookbackWindow()).add("Status", (Object)this.statusAsString()).add("PromoteMode", (Object)this.promoteModeAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "RetrainingStartDate": {
                return Optional.ofNullable(clazz.cast(this.retrainingStartDate()));
            }
            case "RetrainingFrequency": {
                return Optional.ofNullable(clazz.cast(this.retrainingFrequency()));
            }
            case "LookbackWindow": {
                return Optional.ofNullable(clazz.cast(this.lookbackWindow()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "PromoteMode": {
                return Optional.ofNullable(clazz.cast(this.promoteModeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("RetrainingStartDate", RETRAINING_START_DATE_FIELD);
        map.put("RetrainingFrequency", RETRAINING_FREQUENCY_FIELD);
        map.put("LookbackWindow", LOOKBACK_WINDOW_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PromoteMode", PROMOTE_MODE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRetrainingSchedulerResponse, T> g) {
        return obj -> g.apply((DescribeRetrainingSchedulerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private Instant retrainingStartDate;
        private String retrainingFrequency;
        private String lookbackWindow;
        private String status;
        private String promoteMode;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetrainingSchedulerResponse model) {
            super(model);
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.retrainingStartDate(model.retrainingStartDate);
            this.retrainingFrequency(model.retrainingFrequency);
            this.lookbackWindow(model.lookbackWindow);
            this.status(model.status);
            this.promoteMode(model.promoteMode);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getRetrainingStartDate() {
            return this.retrainingStartDate;
        }

        public final void setRetrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
        }

        @Override
        public final Builder retrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
            return this;
        }

        public final String getRetrainingFrequency() {
            return this.retrainingFrequency;
        }

        public final void setRetrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
        }

        @Override
        public final Builder retrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
            return this;
        }

        public final String getLookbackWindow() {
            return this.lookbackWindow;
        }

        public final void setLookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
        }

        @Override
        public final Builder lookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrainingSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPromoteMode() {
            return this.promoteMode;
        }

        public final void setPromoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
        }

        @Override
        public final Builder promoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
            return this;
        }

        @Override
        public final Builder promoteMode(ModelPromoteMode promoteMode) {
            this.promoteMode(promoteMode == null ? null : promoteMode.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DescribeRetrainingSchedulerResponse build() {
            return new DescribeRetrainingSchedulerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRetrainingSchedulerResponse> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder retrainingStartDate(Instant var1);

        public Builder retrainingFrequency(String var1);

        public Builder lookbackWindow(String var1);

        public Builder status(String var1);

        public Builder status(RetrainingSchedulerStatus var1);

        public Builder promoteMode(String var1);

        public Builder promoteMode(ModelPromoteMode var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

