/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerStatus;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceSchedulersRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ListInferenceSchedulersRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceSchedulersRequest.getter(ListInferenceSchedulersRequest::nextToken)).setter(ListInferenceSchedulersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInferenceSchedulersRequest.getter(ListInferenceSchedulersRequest::maxResults)).setter(ListInferenceSchedulersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_BEGINS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerNameBeginsWith").getter(ListInferenceSchedulersRequest.getter(ListInferenceSchedulersRequest::inferenceSchedulerNameBeginsWith)).setter(ListInferenceSchedulersRequest.setter(Builder::inferenceSchedulerNameBeginsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerNameBeginsWith").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ListInferenceSchedulersRequest.getter(ListInferenceSchedulersRequest::modelName)).setter(ListInferenceSchedulersRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListInferenceSchedulersRequest.getter(ListInferenceSchedulersRequest::statusAsString)).setter(ListInferenceSchedulersRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, INFERENCE_SCHEDULER_NAME_BEGINS_WITH_FIELD, MODEL_NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInferenceSchedulersRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String inferenceSchedulerNameBeginsWith;
    private final String modelName;
    private final String status;

    private ListInferenceSchedulersRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inferenceSchedulerNameBeginsWith = builder.inferenceSchedulerNameBeginsWith;
        this.modelName = builder.modelName;
        this.status = builder.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String inferenceSchedulerNameBeginsWith() {
        return this.inferenceSchedulerNameBeginsWith;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerNameBeginsWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceSchedulersRequest)) {
            return false;
        }
        ListInferenceSchedulersRequest other = (ListInferenceSchedulersRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.inferenceSchedulerNameBeginsWith(), other.inferenceSchedulerNameBeginsWith()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceSchedulersRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("InferenceSchedulerNameBeginsWith", (Object)this.inferenceSchedulerNameBeginsWith()).add("ModelName", (Object)this.modelName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "InferenceSchedulerNameBeginsWith": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerNameBeginsWith()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("InferenceSchedulerNameBeginsWith", INFERENCE_SCHEDULER_NAME_BEGINS_WITH_FIELD);
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceSchedulersRequest, T> g) {
        return obj -> g.apply((ListInferenceSchedulersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String inferenceSchedulerNameBeginsWith;
        private String modelName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceSchedulersRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.inferenceSchedulerNameBeginsWith(model.inferenceSchedulerNameBeginsWith);
            this.modelName(model.modelName);
            this.status(model.status);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getInferenceSchedulerNameBeginsWith() {
            return this.inferenceSchedulerNameBeginsWith;
        }

        public final void setInferenceSchedulerNameBeginsWith(String inferenceSchedulerNameBeginsWith) {
            this.inferenceSchedulerNameBeginsWith = inferenceSchedulerNameBeginsWith;
        }

        @Override
        public final Builder inferenceSchedulerNameBeginsWith(String inferenceSchedulerNameBeginsWith) {
            this.inferenceSchedulerNameBeginsWith = inferenceSchedulerNameBeginsWith;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceSchedulersRequest build() {
            return new ListInferenceSchedulersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceSchedulersRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder inferenceSchedulerNameBeginsWith(String var1);

        public Builder modelName(String var1);

        public Builder status(String var1);

        public Builder status(InferenceSchedulerStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

