/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceSchedulersResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListInferenceSchedulersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceSchedulersResponse.getter(ListInferenceSchedulersResponse::nextToken)).setter(ListInferenceSchedulersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<InferenceSchedulerSummary>> INFERENCE_SCHEDULER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceSchedulerSummaries").getter(ListInferenceSchedulersResponse.getter(ListInferenceSchedulersResponse::inferenceSchedulerSummaries)).setter(ListInferenceSchedulersResponse.setter(Builder::inferenceSchedulerSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceSchedulerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INFERENCE_SCHEDULER_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInferenceSchedulersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<InferenceSchedulerSummary> inferenceSchedulerSummaries;

    private ListInferenceSchedulersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.inferenceSchedulerSummaries = builder.inferenceSchedulerSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasInferenceSchedulerSummaries() {
        return this.inferenceSchedulerSummaries != null && !(this.inferenceSchedulerSummaries instanceof SdkAutoConstructList);
    }

    public final List<InferenceSchedulerSummary> inferenceSchedulerSummaries() {
        return this.inferenceSchedulerSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceSchedulerSummaries() ? this.inferenceSchedulerSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceSchedulersResponse)) {
            return false;
        }
        ListInferenceSchedulersResponse other = (ListInferenceSchedulersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasInferenceSchedulerSummaries() == other.hasInferenceSchedulerSummaries() && Objects.equals(this.inferenceSchedulerSummaries(), other.inferenceSchedulerSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceSchedulersResponse").add("NextToken", (Object)this.nextToken()).add("InferenceSchedulerSummaries", this.hasInferenceSchedulerSummaries() ? this.inferenceSchedulerSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "InferenceSchedulerSummaries": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("InferenceSchedulerSummaries", INFERENCE_SCHEDULER_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceSchedulersResponse, T> g) {
        return obj -> g.apply((ListInferenceSchedulersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<InferenceSchedulerSummary> inferenceSchedulerSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceSchedulersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.inferenceSchedulerSummaries(model.inferenceSchedulerSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InferenceSchedulerSummary.Builder> getInferenceSchedulerSummaries() {
            List<InferenceSchedulerSummary.Builder> result = InferenceSchedulerSummariesCopier.copyToBuilder(this.inferenceSchedulerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceSchedulerSummaries(Collection<InferenceSchedulerSummary.BuilderImpl> inferenceSchedulerSummaries) {
            this.inferenceSchedulerSummaries = InferenceSchedulerSummariesCopier.copyFromBuilder(inferenceSchedulerSummaries);
        }

        @Override
        public final Builder inferenceSchedulerSummaries(Collection<InferenceSchedulerSummary> inferenceSchedulerSummaries) {
            this.inferenceSchedulerSummaries = InferenceSchedulerSummariesCopier.copy(inferenceSchedulerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceSchedulerSummaries(InferenceSchedulerSummary ... inferenceSchedulerSummaries) {
            this.inferenceSchedulerSummaries(Arrays.asList(inferenceSchedulerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceSchedulerSummaries(Consumer<InferenceSchedulerSummary.Builder> ... inferenceSchedulerSummaries) {
            this.inferenceSchedulerSummaries(Stream.of(inferenceSchedulerSummaries).map(c -> (InferenceSchedulerSummary)((InferenceSchedulerSummary.Builder)InferenceSchedulerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListInferenceSchedulersResponse build() {
            return new ListInferenceSchedulersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceSchedulersResponse> {
        public Builder nextToken(String var1);

        public Builder inferenceSchedulerSummaries(Collection<InferenceSchedulerSummary> var1);

        public Builder inferenceSchedulerSummaries(InferenceSchedulerSummary ... var1);

        public Builder inferenceSchedulerSummaries(Consumer<InferenceSchedulerSummary.Builder> ... var1);
    }
}

