/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DuplicateTimestamps;
import software.amazon.awssdk.services.lookoutequipment.model.InsufficientSensorData;
import software.amazon.awssdk.services.lookoutequipment.model.InvalidSensorData;
import software.amazon.awssdk.services.lookoutequipment.model.MissingSensorData;
import software.amazon.awssdk.services.lookoutequipment.model.UnsupportedTimestamps;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualitySummary> {
    private static final SdkField<InsufficientSensorData> INSUFFICIENT_SENSOR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InsufficientSensorData").getter(DataQualitySummary.getter(DataQualitySummary::insufficientSensorData)).setter(DataQualitySummary.setter(Builder::insufficientSensorData)).constructor(InsufficientSensorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientSensorData").build()}).build();
    private static final SdkField<MissingSensorData> MISSING_SENSOR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MissingSensorData").getter(DataQualitySummary.getter(DataQualitySummary::missingSensorData)).setter(DataQualitySummary.setter(Builder::missingSensorData)).constructor(MissingSensorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingSensorData").build()}).build();
    private static final SdkField<InvalidSensorData> INVALID_SENSOR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvalidSensorData").getter(DataQualitySummary.getter(DataQualitySummary::invalidSensorData)).setter(DataQualitySummary.setter(Builder::invalidSensorData)).constructor(InvalidSensorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidSensorData").build()}).build();
    private static final SdkField<UnsupportedTimestamps> UNSUPPORTED_TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UnsupportedTimestamps").getter(DataQualitySummary.getter(DataQualitySummary::unsupportedTimestamps)).setter(DataQualitySummary.setter(Builder::unsupportedTimestamps)).constructor(UnsupportedTimestamps::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsupportedTimestamps").build()}).build();
    private static final SdkField<DuplicateTimestamps> DUPLICATE_TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DuplicateTimestamps").getter(DataQualitySummary.getter(DataQualitySummary::duplicateTimestamps)).setter(DataQualitySummary.setter(Builder::duplicateTimestamps)).constructor(DuplicateTimestamps::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DuplicateTimestamps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSUFFICIENT_SENSOR_DATA_FIELD, MISSING_SENSOR_DATA_FIELD, INVALID_SENSOR_DATA_FIELD, UNSUPPORTED_TIMESTAMPS_FIELD, DUPLICATE_TIMESTAMPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualitySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InsufficientSensorData insufficientSensorData;
    private final MissingSensorData missingSensorData;
    private final InvalidSensorData invalidSensorData;
    private final UnsupportedTimestamps unsupportedTimestamps;
    private final DuplicateTimestamps duplicateTimestamps;

    private DataQualitySummary(BuilderImpl builder) {
        this.insufficientSensorData = builder.insufficientSensorData;
        this.missingSensorData = builder.missingSensorData;
        this.invalidSensorData = builder.invalidSensorData;
        this.unsupportedTimestamps = builder.unsupportedTimestamps;
        this.duplicateTimestamps = builder.duplicateTimestamps;
    }

    public final InsufficientSensorData insufficientSensorData() {
        return this.insufficientSensorData;
    }

    public final MissingSensorData missingSensorData() {
        return this.missingSensorData;
    }

    public final InvalidSensorData invalidSensorData() {
        return this.invalidSensorData;
    }

    public final UnsupportedTimestamps unsupportedTimestamps() {
        return this.unsupportedTimestamps;
    }

    public final DuplicateTimestamps duplicateTimestamps() {
        return this.duplicateTimestamps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insufficientSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsupportedTimestamps());
        hashCode = 31 * hashCode + Objects.hashCode(this.duplicateTimestamps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualitySummary)) {
            return false;
        }
        DataQualitySummary other = (DataQualitySummary)obj;
        return Objects.equals(this.insufficientSensorData(), other.insufficientSensorData()) && Objects.equals(this.missingSensorData(), other.missingSensorData()) && Objects.equals(this.invalidSensorData(), other.invalidSensorData()) && Objects.equals(this.unsupportedTimestamps(), other.unsupportedTimestamps()) && Objects.equals(this.duplicateTimestamps(), other.duplicateTimestamps());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualitySummary").add("InsufficientSensorData", (Object)this.insufficientSensorData()).add("MissingSensorData", (Object)this.missingSensorData()).add("InvalidSensorData", (Object)this.invalidSensorData()).add("UnsupportedTimestamps", (Object)this.unsupportedTimestamps()).add("DuplicateTimestamps", (Object)this.duplicateTimestamps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsufficientSensorData": {
                return Optional.ofNullable(clazz.cast(this.insufficientSensorData()));
            }
            case "MissingSensorData": {
                return Optional.ofNullable(clazz.cast(this.missingSensorData()));
            }
            case "InvalidSensorData": {
                return Optional.ofNullable(clazz.cast(this.invalidSensorData()));
            }
            case "UnsupportedTimestamps": {
                return Optional.ofNullable(clazz.cast(this.unsupportedTimestamps()));
            }
            case "DuplicateTimestamps": {
                return Optional.ofNullable(clazz.cast(this.duplicateTimestamps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InsufficientSensorData", INSUFFICIENT_SENSOR_DATA_FIELD);
        map.put("MissingSensorData", MISSING_SENSOR_DATA_FIELD);
        map.put("InvalidSensorData", INVALID_SENSOR_DATA_FIELD);
        map.put("UnsupportedTimestamps", UNSUPPORTED_TIMESTAMPS_FIELD);
        map.put("DuplicateTimestamps", DUPLICATE_TIMESTAMPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualitySummary, T> g) {
        return obj -> g.apply((DataQualitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InsufficientSensorData insufficientSensorData;
        private MissingSensorData missingSensorData;
        private InvalidSensorData invalidSensorData;
        private UnsupportedTimestamps unsupportedTimestamps;
        private DuplicateTimestamps duplicateTimestamps;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualitySummary model) {
            this.insufficientSensorData(model.insufficientSensorData);
            this.missingSensorData(model.missingSensorData);
            this.invalidSensorData(model.invalidSensorData);
            this.unsupportedTimestamps(model.unsupportedTimestamps);
            this.duplicateTimestamps(model.duplicateTimestamps);
        }

        public final InsufficientSensorData.Builder getInsufficientSensorData() {
            return this.insufficientSensorData != null ? this.insufficientSensorData.toBuilder() : null;
        }

        public final void setInsufficientSensorData(InsufficientSensorData.BuilderImpl insufficientSensorData) {
            this.insufficientSensorData = insufficientSensorData != null ? insufficientSensorData.build() : null;
        }

        @Override
        public final Builder insufficientSensorData(InsufficientSensorData insufficientSensorData) {
            this.insufficientSensorData = insufficientSensorData;
            return this;
        }

        public final MissingSensorData.Builder getMissingSensorData() {
            return this.missingSensorData != null ? this.missingSensorData.toBuilder() : null;
        }

        public final void setMissingSensorData(MissingSensorData.BuilderImpl missingSensorData) {
            this.missingSensorData = missingSensorData != null ? missingSensorData.build() : null;
        }

        @Override
        public final Builder missingSensorData(MissingSensorData missingSensorData) {
            this.missingSensorData = missingSensorData;
            return this;
        }

        public final InvalidSensorData.Builder getInvalidSensorData() {
            return this.invalidSensorData != null ? this.invalidSensorData.toBuilder() : null;
        }

        public final void setInvalidSensorData(InvalidSensorData.BuilderImpl invalidSensorData) {
            this.invalidSensorData = invalidSensorData != null ? invalidSensorData.build() : null;
        }

        @Override
        public final Builder invalidSensorData(InvalidSensorData invalidSensorData) {
            this.invalidSensorData = invalidSensorData;
            return this;
        }

        public final UnsupportedTimestamps.Builder getUnsupportedTimestamps() {
            return this.unsupportedTimestamps != null ? this.unsupportedTimestamps.toBuilder() : null;
        }

        public final void setUnsupportedTimestamps(UnsupportedTimestamps.BuilderImpl unsupportedTimestamps) {
            this.unsupportedTimestamps = unsupportedTimestamps != null ? unsupportedTimestamps.build() : null;
        }

        @Override
        public final Builder unsupportedTimestamps(UnsupportedTimestamps unsupportedTimestamps) {
            this.unsupportedTimestamps = unsupportedTimestamps;
            return this;
        }

        public final DuplicateTimestamps.Builder getDuplicateTimestamps() {
            return this.duplicateTimestamps != null ? this.duplicateTimestamps.toBuilder() : null;
        }

        public final void setDuplicateTimestamps(DuplicateTimestamps.BuilderImpl duplicateTimestamps) {
            this.duplicateTimestamps = duplicateTimestamps != null ? duplicateTimestamps.build() : null;
        }

        @Override
        public final Builder duplicateTimestamps(DuplicateTimestamps duplicateTimestamps) {
            this.duplicateTimestamps = duplicateTimestamps;
            return this;
        }

        public DataQualitySummary build() {
            return new DataQualitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualitySummary> {
        public Builder insufficientSensorData(InsufficientSensorData var1);

        default public Builder insufficientSensorData(Consumer<InsufficientSensorData.Builder> insufficientSensorData) {
            return this.insufficientSensorData((InsufficientSensorData)((InsufficientSensorData.Builder)InsufficientSensorData.builder().applyMutation(insufficientSensorData)).build());
        }

        public Builder missingSensorData(MissingSensorData var1);

        default public Builder missingSensorData(Consumer<MissingSensorData.Builder> missingSensorData) {
            return this.missingSensorData((MissingSensorData)((MissingSensorData.Builder)MissingSensorData.builder().applyMutation(missingSensorData)).build());
        }

        public Builder invalidSensorData(InvalidSensorData var1);

        default public Builder invalidSensorData(Consumer<InvalidSensorData.Builder> invalidSensorData) {
            return this.invalidSensorData((InvalidSensorData)((InvalidSensorData.Builder)InvalidSensorData.builder().applyMutation(invalidSensorData)).build());
        }

        public Builder unsupportedTimestamps(UnsupportedTimestamps var1);

        default public Builder unsupportedTimestamps(Consumer<UnsupportedTimestamps.Builder> unsupportedTimestamps) {
            return this.unsupportedTimestamps((UnsupportedTimestamps)((UnsupportedTimestamps.Builder)UnsupportedTimestamps.builder().applyMutation(unsupportedTimestamps)).build());
        }

        public Builder duplicateTimestamps(DuplicateTimestamps var1);

        default public Builder duplicateTimestamps(Consumer<DuplicateTimestamps.Builder> duplicateTimestamps) {
            return this.duplicateTimestamps((DuplicateTimestamps)((DuplicateTimestamps.Builder)DuplicateTimestamps.builder().applyMutation(duplicateTimestamps)).build());
        }
    }
}

