/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrainingSchedulerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrainingSchedulerSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(RetrainingSchedulerSummary.getter(RetrainingSchedulerSummary::modelName)).setter(RetrainingSchedulerSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(RetrainingSchedulerSummary.getter(RetrainingSchedulerSummary::modelArn)).setter(RetrainingSchedulerSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RetrainingSchedulerSummary.getter(RetrainingSchedulerSummary::statusAsString)).setter(RetrainingSchedulerSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> RETRAINING_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RetrainingStartDate").getter(RetrainingSchedulerSummary.getter(RetrainingSchedulerSummary::retrainingStartDate)).setter(RetrainingSchedulerSummary.setter(Builder::retrainingStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingStartDate").build()}).build();
    private static final SdkField<String> RETRAINING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrainingFrequency").getter(RetrainingSchedulerSummary.getter(RetrainingSchedulerSummary::retrainingFrequency)).setter(RetrainingSchedulerSummary.setter(Builder::retrainingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingFrequency").build()}).build();
    private static final SdkField<String> LOOKBACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackWindow").getter(RetrainingSchedulerSummary.getter(RetrainingSchedulerSummary::lookbackWindow)).setter(RetrainingSchedulerSummary.setter(Builder::lookbackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, STATUS_FIELD, RETRAINING_START_DATE_FIELD, RETRAINING_FREQUENCY_FIELD, LOOKBACK_WINDOW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrainingSchedulerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelArn;
    private final String status;
    private final Instant retrainingStartDate;
    private final String retrainingFrequency;
    private final String lookbackWindow;

    private RetrainingSchedulerSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.status = builder.status;
        this.retrainingStartDate = builder.retrainingStartDate;
        this.retrainingFrequency = builder.retrainingFrequency;
        this.lookbackWindow = builder.lookbackWindow;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final RetrainingSchedulerStatus status() {
        return RetrainingSchedulerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant retrainingStartDate() {
        return this.retrainingStartDate;
    }

    public final String retrainingFrequency() {
        return this.retrainingFrequency;
    }

    public final String lookbackWindow() {
        return this.lookbackWindow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackWindow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrainingSchedulerSummary)) {
            return false;
        }
        RetrainingSchedulerSummary other = (RetrainingSchedulerSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.retrainingStartDate(), other.retrainingStartDate()) && Objects.equals(this.retrainingFrequency(), other.retrainingFrequency()) && Objects.equals(this.lookbackWindow(), other.lookbackWindow());
    }

    public final String toString() {
        return ToString.builder((String)"RetrainingSchedulerSummary").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("Status", (Object)this.statusAsString()).add("RetrainingStartDate", (Object)this.retrainingStartDate()).add("RetrainingFrequency", (Object)this.retrainingFrequency()).add("LookbackWindow", (Object)this.lookbackWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RetrainingStartDate": {
                return Optional.ofNullable(clazz.cast(this.retrainingStartDate()));
            }
            case "RetrainingFrequency": {
                return Optional.ofNullable(clazz.cast(this.retrainingFrequency()));
            }
            case "LookbackWindow": {
                return Optional.ofNullable(clazz.cast(this.lookbackWindow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RetrainingStartDate", RETRAINING_START_DATE_FIELD);
        map.put("RetrainingFrequency", RETRAINING_FREQUENCY_FIELD);
        map.put("LookbackWindow", LOOKBACK_WINDOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrainingSchedulerSummary, T> g) {
        return obj -> g.apply((RetrainingSchedulerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private String status;
        private Instant retrainingStartDate;
        private String retrainingFrequency;
        private String lookbackWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrainingSchedulerSummary model) {
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.status(model.status);
            this.retrainingStartDate(model.retrainingStartDate);
            this.retrainingFrequency(model.retrainingFrequency);
            this.lookbackWindow(model.lookbackWindow);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrainingSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getRetrainingStartDate() {
            return this.retrainingStartDate;
        }

        public final void setRetrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
        }

        @Override
        public final Builder retrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
            return this;
        }

        public final String getRetrainingFrequency() {
            return this.retrainingFrequency;
        }

        public final void setRetrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
        }

        @Override
        public final Builder retrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
            return this;
        }

        public final String getLookbackWindow() {
            return this.lookbackWindow;
        }

        public final void setLookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
        }

        @Override
        public final Builder lookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        public RetrainingSchedulerSummary build() {
            return new RetrainingSchedulerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrainingSchedulerSummary> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder status(String var1);

        public Builder status(RetrainingSchedulerStatus var1);

        public Builder retrainingStartDate(Instant var1);

        public Builder retrainingFrequency(String var1);

        public Builder lookbackWindow(String var1);
    }
}

