/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LabelRating;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLabelRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, CreateLabelRequest> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupName").getter(CreateLabelRequest.getter(CreateLabelRequest::labelGroupName)).setter(CreateLabelRequest.setter(Builder::labelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateLabelRequest.getter(CreateLabelRequest::startTime)).setter(CreateLabelRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CreateLabelRequest.getter(CreateLabelRequest::endTime)).setter(CreateLabelRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> RATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rating").getter(CreateLabelRequest.getter(CreateLabelRequest::ratingAsString)).setter(CreateLabelRequest.setter(Builder::rating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rating").build()}).build();
    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaultCode").getter(CreateLabelRequest.getter(CreateLabelRequest::faultCode)).setter(CreateLabelRequest.setter(Builder::faultCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(CreateLabelRequest.getter(CreateLabelRequest::notes)).setter(CreateLabelRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Equipment").getter(CreateLabelRequest.getter(CreateLabelRequest::equipment)).setter(CreateLabelRequest.setter(Builder::equipment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLabelRequest.getter(CreateLabelRequest::clientToken)).setter(CreateLabelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, RATING_FIELD, FAULT_CODE_FIELD, NOTES_FIELD, EQUIPMENT_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LabelGroupName", LABEL_GROUP_NAME_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("Rating", RATING_FIELD);
            this.put("FaultCode", FAULT_CODE_FIELD);
            this.put("Notes", NOTES_FIELD);
            this.put("Equipment", EQUIPMENT_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String labelGroupName;
    private final Instant startTime;
    private final Instant endTime;
    private final String rating;
    private final String faultCode;
    private final String notes;
    private final String equipment;
    private final String clientToken;

    private CreateLabelRequest(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.rating = builder.rating;
        this.faultCode = builder.faultCode;
        this.notes = builder.notes;
        this.equipment = builder.equipment;
        this.clientToken = builder.clientToken;
    }

    public final String labelGroupName() {
        return this.labelGroupName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final LabelRating rating() {
        return LabelRating.fromValue(this.rating);
    }

    public final String ratingAsString() {
        return this.rating;
    }

    public final String faultCode() {
        return this.faultCode;
    }

    public final String notes() {
        return this.notes;
    }

    public final String equipment() {
        return this.equipment;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ratingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.equipment());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelRequest)) {
            return false;
        }
        CreateLabelRequest other = (CreateLabelRequest)((Object)obj);
        return Objects.equals(this.labelGroupName(), other.labelGroupName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ratingAsString(), other.ratingAsString()) && Objects.equals(this.faultCode(), other.faultCode()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.equipment(), other.equipment()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLabelRequest").add("LabelGroupName", (Object)this.labelGroupName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Rating", (Object)this.ratingAsString()).add("FaultCode", (Object)this.faultCode()).add("Notes", (Object)this.notes()).add("Equipment", (Object)this.equipment()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelGroupName": {
                return Optional.ofNullable(clazz.cast(this.labelGroupName()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Rating": {
                return Optional.ofNullable(clazz.cast(this.ratingAsString()));
            }
            case "FaultCode": {
                return Optional.ofNullable(clazz.cast(this.faultCode()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "Equipment": {
                return Optional.ofNullable(clazz.cast(this.equipment()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLabelRequest, T> g) {
        return obj -> g.apply((CreateLabelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String labelGroupName;
        private Instant startTime;
        private Instant endTime;
        private String rating;
        private String faultCode;
        private String notes;
        private String equipment;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelRequest model) {
            super(model);
            this.labelGroupName(model.labelGroupName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.rating(model.rating);
            this.faultCode(model.faultCode);
            this.notes(model.notes);
            this.equipment(model.equipment);
            this.clientToken(model.clientToken);
        }

        public final String getLabelGroupName() {
            return this.labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRating() {
            return this.rating;
        }

        public final void setRating(String rating) {
            this.rating = rating;
        }

        @Override
        public final Builder rating(String rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public final Builder rating(LabelRating rating) {
            this.rating(rating == null ? null : rating.toString());
            return this;
        }

        public final String getFaultCode() {
            return this.faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getEquipment() {
            return this.equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLabelRequest build() {
            return new CreateLabelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLabelRequest> {
        public Builder labelGroupName(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder rating(String var1);

        public Builder rating(LabelRating var1);

        public Builder faultCode(String var1);

        public Builder notes(String var1);

        public Builder equipment(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

