/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerStatus;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelQuality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceSchedulerResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, CreateInferenceSchedulerResponse> {
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerArn").getter(CreateInferenceSchedulerResponse.getter(CreateInferenceSchedulerResponse::inferenceSchedulerArn)).setter(CreateInferenceSchedulerResponse.setter(Builder::inferenceSchedulerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(CreateInferenceSchedulerResponse.getter(CreateInferenceSchedulerResponse::inferenceSchedulerName)).setter(CreateInferenceSchedulerResponse.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateInferenceSchedulerResponse.getter(CreateInferenceSchedulerResponse::statusAsString)).setter(CreateInferenceSchedulerResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelQuality").getter(CreateInferenceSchedulerResponse.getter(CreateInferenceSchedulerResponse::modelQualityAsString)).setter(CreateInferenceSchedulerResponse.setter(Builder::modelQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_SCHEDULER_ARN_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, STATUS_FIELD, MODEL_QUALITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InferenceSchedulerArn", INFERENCE_SCHEDULER_ARN_FIELD);
            this.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ModelQuality", MODEL_QUALITY_FIELD);
        }
    });
    private final String inferenceSchedulerArn;
    private final String inferenceSchedulerName;
    private final String status;
    private final String modelQuality;

    private CreateInferenceSchedulerResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.status = builder.status;
        this.modelQuality = builder.modelQuality;
    }

    public final String inferenceSchedulerArn() {
        return this.inferenceSchedulerArn;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(this.modelQuality);
    }

    public final String modelQualityAsString() {
        return this.modelQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceSchedulerResponse)) {
            return false;
        }
        CreateInferenceSchedulerResponse other = (CreateInferenceSchedulerResponse)((Object)obj);
        return Objects.equals(this.inferenceSchedulerArn(), other.inferenceSchedulerArn()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelQualityAsString(), other.modelQualityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceSchedulerResponse").add("InferenceSchedulerArn", (Object)this.inferenceSchedulerArn()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("Status", (Object)this.statusAsString()).add("ModelQuality", (Object)this.modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceSchedulerArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerArn()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelQuality": {
                return Optional.ofNullable(clazz.cast(this.modelQualityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceSchedulerResponse, T> g) {
        return obj -> g.apply((CreateInferenceSchedulerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String inferenceSchedulerArn;
        private String inferenceSchedulerName;
        private String status;
        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceSchedulerResponse model) {
            super(model);
            this.inferenceSchedulerArn(model.inferenceSchedulerArn);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.status(model.status);
            this.modelQuality(model.modelQuality);
        }

        public final String getInferenceSchedulerArn() {
            return this.inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelQuality() {
            return this.modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public CreateInferenceSchedulerResponse build() {
            return new CreateInferenceSchedulerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceSchedulerResponse> {
        public Builder inferenceSchedulerArn(String var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder status(String var1);

        public Builder status(InferenceSchedulerStatus var1);

        public Builder modelQuality(String var1);

        public Builder modelQuality(ModelQuality var1);
    }
}

