/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse;

public class ListLabelsPublisher
implements SdkPublisher<ListLabelsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListLabelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLabelsPublisher(LookoutEquipmentAsyncClient client, ListLabelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLabelsPublisher(LookoutEquipmentAsyncClient client, ListLabelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLabelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLabelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLabelsResponseFetcher
    implements AsyncPageFetcher<ListLabelsResponse> {
        private ListLabelsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLabelsResponse> nextPage(ListLabelsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelsPublisher.this.client.listLabels(ListLabelsPublisher.this.firstRequest);
            }
            return ListLabelsPublisher.this.client.listLabels((ListLabelsRequest)((Object)ListLabelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

