/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.LabelSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.LabelSummary;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLabelsResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListLabelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLabelsResponse.getter(ListLabelsResponse::nextToken)).setter(ListLabelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<LabelSummary>> LABEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelSummaries").getter(ListLabelsResponse.getter(ListLabelsResponse::labelSummaries)).setter(ListLabelsResponse.setter(Builder::labelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, LABEL_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<LabelSummary> labelSummaries;

    private ListLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.labelSummaries = builder.labelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasLabelSummaries() {
        return this.labelSummaries != null && !(this.labelSummaries instanceof SdkAutoConstructList);
    }

    public final List<LabelSummary> labelSummaries() {
        return this.labelSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelSummaries() ? this.labelSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelsResponse)) {
            return false;
        }
        ListLabelsResponse other = (ListLabelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasLabelSummaries() == other.hasLabelSummaries() && Objects.equals(this.labelSummaries(), other.labelSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListLabelsResponse").add("NextToken", (Object)this.nextToken()).add("LabelSummaries", this.hasLabelSummaries() ? this.labelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "LabelSummaries": {
                return Optional.ofNullable(clazz.cast(this.labelSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelsResponse, T> g) {
        return obj -> g.apply((ListLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<LabelSummary> labelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.labelSummaries(model.labelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LabelSummary.Builder> getLabelSummaries() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.labelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabelSummaries(Collection<LabelSummary.BuilderImpl> labelSummaries) {
            this.labelSummaries = LabelSummariesCopier.copyFromBuilder(labelSummaries);
        }

        @Override
        public final Builder labelSummaries(Collection<LabelSummary> labelSummaries) {
            this.labelSummaries = LabelSummariesCopier.copy(labelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelSummaries(LabelSummary ... labelSummaries) {
            this.labelSummaries(Arrays.asList(labelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelSummaries(Consumer<LabelSummary.Builder> ... labelSummaries) {
            this.labelSummaries(Stream.of(labelSummaries).map(c -> (LabelSummary)((LabelSummary.Builder)LabelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLabelsResponse build() {
            return new ListLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLabelsResponse> {
        public Builder nextToken(String var1);

        public Builder labelSummaries(Collection<LabelSummary> var1);

        public Builder labelSummaries(LabelSummary ... var1);

        public Builder labelSummaries(Consumer<LabelSummary.Builder> ... var1);
    }
}

