/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse;

public class ListDataIngestionJobsIterable
implements SdkIterable<ListDataIngestionJobsResponse> {
    private final LookoutEquipmentClient client;
    private final ListDataIngestionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataIngestionJobsIterable(LookoutEquipmentClient client, ListDataIngestionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataIngestionJobsResponseFetcher();
    }

    public Iterator<ListDataIngestionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDataIngestionJobsResponseFetcher
    implements SyncPageFetcher<ListDataIngestionJobsResponse> {
        private ListDataIngestionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIngestionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataIngestionJobsResponse nextPage(ListDataIngestionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIngestionJobsIterable.this.client.listDataIngestionJobs(ListDataIngestionJobsIterable.this.firstRequest);
            }
            return ListDataIngestionJobsIterable.this.client.listDataIngestionJobs((ListDataIngestionJobsRequest)((Object)ListDataIngestionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

