/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse;

public class ListLabelsIterable
implements SdkIterable<ListLabelsResponse> {
    private final LookoutEquipmentClient client;
    private final ListLabelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLabelsIterable(LookoutEquipmentClient client, ListLabelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLabelsResponseFetcher();
    }

    public Iterator<ListLabelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLabelsResponseFetcher
    implements SyncPageFetcher<ListLabelsResponse> {
        private ListLabelsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLabelsResponse nextPage(ListLabelsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelsIterable.this.client.listLabels(ListLabelsIterable.this.firstRequest);
            }
            return ListLabelsIterable.this.client.listLabels((ListLabelsRequest)((Object)ListLabelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

