/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeModelResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeModelResponse.getter(DescribeModelResponse::modelName)).setter(DescribeModelResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(DescribeModelResponse.getter(DescribeModelResponse::modelArn)).setter(DescribeModelResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DescribeModelResponse.getter(DescribeModelResponse::datasetName)).setter(DescribeModelResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeModelResponse.getter(DescribeModelResponse::datasetArn)).setter(DescribeModelResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(DescribeModelResponse.getter(DescribeModelResponse::schema)).setter(DescribeModelResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(), JsonValueTrait.create()}).build();
    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration").getter(DescribeModelResponse.getter(DescribeModelResponse::labelsInputConfiguration)).setter(DescribeModelResponse.setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build()}).build();
    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingDataStartTime").getter(DescribeModelResponse.getter(DescribeModelResponse::trainingDataStartTime)).setter(DescribeModelResponse.setter(Builder::trainingDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingDataEndTime").getter(DescribeModelResponse.getter(DescribeModelResponse::trainingDataEndTime)).setter(DescribeModelResponse.setter(Builder::trainingDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataEndTime").build()}).build();
    private static final SdkField<Instant> EVALUATION_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationDataStartTime").getter(DescribeModelResponse.getter(DescribeModelResponse::evaluationDataStartTime)).setter(DescribeModelResponse.setter(Builder::evaluationDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataStartTime").build()}).build();
    private static final SdkField<Instant> EVALUATION_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationDataEndTime").getter(DescribeModelResponse.getter(DescribeModelResponse::evaluationDataEndTime)).setter(DescribeModelResponse.setter(Builder::evaluationDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataEndTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeModelResponse.getter(DescribeModelResponse::roleArn)).setter(DescribeModelResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<DataPreProcessingConfiguration> DATA_PRE_PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPreProcessingConfiguration").getter(DescribeModelResponse.getter(DescribeModelResponse::dataPreProcessingConfiguration)).setter(DescribeModelResponse.setter(Builder::dataPreProcessingConfiguration)).constructor(DataPreProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreProcessingConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeModelResponse.getter(DescribeModelResponse::statusAsString)).setter(DescribeModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> TRAINING_EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingExecutionStartTime").getter(DescribeModelResponse.getter(DescribeModelResponse::trainingExecutionStartTime)).setter(DescribeModelResponse.setter(Builder::trainingExecutionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingExecutionEndTime").getter(DescribeModelResponse.getter(DescribeModelResponse::trainingExecutionEndTime)).setter(DescribeModelResponse.setter(Builder::trainingExecutionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionEndTime").build()}).build();
    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailedReason").getter(DescribeModelResponse.getter(DescribeModelResponse::failedReason)).setter(DescribeModelResponse.setter(Builder::failedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()}).build();
    private static final SdkField<String> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelMetrics").getter(DescribeModelResponse.getter(DescribeModelResponse::modelMetrics)).setter(DescribeModelResponse.setter(Builder::modelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build(), JsonValueTrait.create()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeModelResponse.getter(DescribeModelResponse::lastUpdatedTime)).setter(DescribeModelResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeModelResponse.getter(DescribeModelResponse::createdAt)).setter(DescribeModelResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(DescribeModelResponse.getter(DescribeModelResponse::serverSideKmsKeyId)).setter(DescribeModelResponse.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<String> OFF_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OffCondition").getter(DescribeModelResponse.getter(DescribeModelResponse::offCondition)).setter(DescribeModelResponse.setter(Builder::offCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffCondition").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceModelVersionArn").getter(DescribeModelResponse.getter(DescribeModelResponse::sourceModelVersionArn)).setter(DescribeModelResponse.setter(Builder::sourceModelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVersionArn").build()}).build();
    private static final SdkField<Instant> IMPORT_JOB_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImportJobStartTime").getter(DescribeModelResponse.getter(DescribeModelResponse::importJobStartTime)).setter(DescribeModelResponse.setter(Builder::importJobStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobStartTime").build()}).build();
    private static final SdkField<Instant> IMPORT_JOB_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImportJobEndTime").getter(DescribeModelResponse.getter(DescribeModelResponse::importJobEndTime)).setter(DescribeModelResponse.setter(Builder::importJobEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobEndTime").build()}).build();
    private static final SdkField<Long> ACTIVE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ActiveModelVersion").getter(DescribeModelResponse.getter(DescribeModelResponse::activeModelVersion)).setter(DescribeModelResponse.setter(Builder::activeModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersion").build()}).build();
    private static final SdkField<String> ACTIVE_MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveModelVersionArn").getter(DescribeModelResponse.getter(DescribeModelResponse::activeModelVersionArn)).setter(DescribeModelResponse.setter(Builder::activeModelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersionArn").build()}).build();
    private static final SdkField<Instant> MODEL_VERSION_ACTIVATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModelVersionActivatedAt").getter(DescribeModelResponse.getter(DescribeModelResponse::modelVersionActivatedAt)).setter(DescribeModelResponse.setter(Builder::modelVersionActivatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionActivatedAt").build()}).build();
    private static final SdkField<Long> PREVIOUS_ACTIVE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PreviousActiveModelVersion").getter(DescribeModelResponse.getter(DescribeModelResponse::previousActiveModelVersion)).setter(DescribeModelResponse.setter(Builder::previousActiveModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousActiveModelVersion").build()}).build();
    private static final SdkField<String> PREVIOUS_ACTIVE_MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousActiveModelVersionArn").getter(DescribeModelResponse.getter(DescribeModelResponse::previousActiveModelVersionArn)).setter(DescribeModelResponse.setter(Builder::previousActiveModelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousActiveModelVersionArn").build()}).build();
    private static final SdkField<Instant> PREVIOUS_MODEL_VERSION_ACTIVATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PreviousModelVersionActivatedAt").getter(DescribeModelResponse.getter(DescribeModelResponse::previousModelVersionActivatedAt)).setter(DescribeModelResponse.setter(Builder::previousModelVersionActivatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousModelVersionActivatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, DATASET_NAME_FIELD, DATASET_ARN_FIELD, SCHEMA_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, EVALUATION_DATA_START_TIME_FIELD, EVALUATION_DATA_END_TIME_FIELD, ROLE_ARN_FIELD, DATA_PRE_PROCESSING_CONFIGURATION_FIELD, STATUS_FIELD, TRAINING_EXECUTION_START_TIME_FIELD, TRAINING_EXECUTION_END_TIME_FIELD, FAILED_REASON_FIELD, MODEL_METRICS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_AT_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, OFF_CONDITION_FIELD, SOURCE_MODEL_VERSION_ARN_FIELD, IMPORT_JOB_START_TIME_FIELD, IMPORT_JOB_END_TIME_FIELD, ACTIVE_MODEL_VERSION_FIELD, ACTIVE_MODEL_VERSION_ARN_FIELD, MODEL_VERSION_ACTIVATED_AT_FIELD, PREVIOUS_ACTIVE_MODEL_VERSION_FIELD, PREVIOUS_ACTIVE_MODEL_VERSION_ARN_FIELD, PREVIOUS_MODEL_VERSION_ACTIVATED_AT_FIELD));
    private final String modelName;
    private final String modelArn;
    private final String datasetName;
    private final String datasetArn;
    private final String schema;
    private final LabelsInputConfiguration labelsInputConfiguration;
    private final Instant trainingDataStartTime;
    private final Instant trainingDataEndTime;
    private final Instant evaluationDataStartTime;
    private final Instant evaluationDataEndTime;
    private final String roleArn;
    private final DataPreProcessingConfiguration dataPreProcessingConfiguration;
    private final String status;
    private final Instant trainingExecutionStartTime;
    private final Instant trainingExecutionEndTime;
    private final String failedReason;
    private final String modelMetrics;
    private final Instant lastUpdatedTime;
    private final Instant createdAt;
    private final String serverSideKmsKeyId;
    private final String offCondition;
    private final String sourceModelVersionArn;
    private final Instant importJobStartTime;
    private final Instant importJobEndTime;
    private final Long activeModelVersion;
    private final String activeModelVersionArn;
    private final Instant modelVersionActivatedAt;
    private final Long previousActiveModelVersion;
    private final String previousActiveModelVersionArn;
    private final Instant previousModelVersionActivatedAt;

    private DescribeModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.schema = builder.schema;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.evaluationDataStartTime = builder.evaluationDataStartTime;
        this.evaluationDataEndTime = builder.evaluationDataEndTime;
        this.roleArn = builder.roleArn;
        this.dataPreProcessingConfiguration = builder.dataPreProcessingConfiguration;
        this.status = builder.status;
        this.trainingExecutionStartTime = builder.trainingExecutionStartTime;
        this.trainingExecutionEndTime = builder.trainingExecutionEndTime;
        this.failedReason = builder.failedReason;
        this.modelMetrics = builder.modelMetrics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdAt = builder.createdAt;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.offCondition = builder.offCondition;
        this.sourceModelVersionArn = builder.sourceModelVersionArn;
        this.importJobStartTime = builder.importJobStartTime;
        this.importJobEndTime = builder.importJobEndTime;
        this.activeModelVersion = builder.activeModelVersion;
        this.activeModelVersionArn = builder.activeModelVersionArn;
        this.modelVersionActivatedAt = builder.modelVersionActivatedAt;
        this.previousActiveModelVersion = builder.previousActiveModelVersion;
        this.previousActiveModelVersionArn = builder.previousActiveModelVersionArn;
        this.previousModelVersionActivatedAt = builder.previousModelVersionActivatedAt;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String schema() {
        return this.schema;
    }

    public final LabelsInputConfiguration labelsInputConfiguration() {
        return this.labelsInputConfiguration;
    }

    public final Instant trainingDataStartTime() {
        return this.trainingDataStartTime;
    }

    public final Instant trainingDataEndTime() {
        return this.trainingDataEndTime;
    }

    public final Instant evaluationDataStartTime() {
        return this.evaluationDataStartTime;
    }

    public final Instant evaluationDataEndTime() {
        return this.evaluationDataEndTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DataPreProcessingConfiguration dataPreProcessingConfiguration() {
        return this.dataPreProcessingConfiguration;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant trainingExecutionStartTime() {
        return this.trainingExecutionStartTime;
    }

    public final Instant trainingExecutionEndTime() {
        return this.trainingExecutionEndTime;
    }

    public final String failedReason() {
        return this.failedReason;
    }

    public final String modelMetrics() {
        return this.modelMetrics;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final String offCondition() {
        return this.offCondition;
    }

    public final String sourceModelVersionArn() {
        return this.sourceModelVersionArn;
    }

    public final Instant importJobStartTime() {
        return this.importJobStartTime;
    }

    public final Instant importJobEndTime() {
        return this.importJobEndTime;
    }

    public final Long activeModelVersion() {
        return this.activeModelVersion;
    }

    public final String activeModelVersionArn() {
        return this.activeModelVersionArn;
    }

    public final Instant modelVersionActivatedAt() {
        return this.modelVersionActivatedAt;
    }

    public final Long previousActiveModelVersion() {
        return this.previousActiveModelVersion;
    }

    public final String previousActiveModelVersionArn() {
        return this.previousActiveModelVersionArn;
    }

    public final Instant previousModelVersionActivatedAt() {
        return this.previousModelVersionActivatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPreProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingExecutionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingExecutionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionActivatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousActiveModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousActiveModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousModelVersionActivatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResponse)) {
            return false;
        }
        DescribeModelResponse other = (DescribeModelResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.labelsInputConfiguration(), other.labelsInputConfiguration()) && Objects.equals(this.trainingDataStartTime(), other.trainingDataStartTime()) && Objects.equals(this.trainingDataEndTime(), other.trainingDataEndTime()) && Objects.equals(this.evaluationDataStartTime(), other.evaluationDataStartTime()) && Objects.equals(this.evaluationDataEndTime(), other.evaluationDataEndTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataPreProcessingConfiguration(), other.dataPreProcessingConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.trainingExecutionStartTime(), other.trainingExecutionStartTime()) && Objects.equals(this.trainingExecutionEndTime(), other.trainingExecutionEndTime()) && Objects.equals(this.failedReason(), other.failedReason()) && Objects.equals(this.modelMetrics(), other.modelMetrics()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && Objects.equals(this.offCondition(), other.offCondition()) && Objects.equals(this.sourceModelVersionArn(), other.sourceModelVersionArn()) && Objects.equals(this.importJobStartTime(), other.importJobStartTime()) && Objects.equals(this.importJobEndTime(), other.importJobEndTime()) && Objects.equals(this.activeModelVersion(), other.activeModelVersion()) && Objects.equals(this.activeModelVersionArn(), other.activeModelVersionArn()) && Objects.equals(this.modelVersionActivatedAt(), other.modelVersionActivatedAt()) && Objects.equals(this.previousActiveModelVersion(), other.previousActiveModelVersion()) && Objects.equals(this.previousActiveModelVersionArn(), other.previousActiveModelVersionArn()) && Objects.equals(this.previousModelVersionActivatedAt(), other.previousModelVersionActivatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelResponse").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("DatasetName", (Object)this.datasetName()).add("DatasetArn", (Object)this.datasetArn()).add("Schema", (Object)this.schema()).add("LabelsInputConfiguration", (Object)this.labelsInputConfiguration()).add("TrainingDataStartTime", (Object)this.trainingDataStartTime()).add("TrainingDataEndTime", (Object)this.trainingDataEndTime()).add("EvaluationDataStartTime", (Object)this.evaluationDataStartTime()).add("EvaluationDataEndTime", (Object)this.evaluationDataEndTime()).add("RoleArn", (Object)this.roleArn()).add("DataPreProcessingConfiguration", (Object)this.dataPreProcessingConfiguration()).add("Status", (Object)this.statusAsString()).add("TrainingExecutionStartTime", (Object)this.trainingExecutionStartTime()).add("TrainingExecutionEndTime", (Object)this.trainingExecutionEndTime()).add("FailedReason", (Object)this.failedReason()).add("ModelMetrics", (Object)this.modelMetrics()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedAt", (Object)this.createdAt()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("OffCondition", (Object)this.offCondition()).add("SourceModelVersionArn", (Object)this.sourceModelVersionArn()).add("ImportJobStartTime", (Object)this.importJobStartTime()).add("ImportJobEndTime", (Object)this.importJobEndTime()).add("ActiveModelVersion", (Object)this.activeModelVersion()).add("ActiveModelVersionArn", (Object)this.activeModelVersionArn()).add("ModelVersionActivatedAt", (Object)this.modelVersionActivatedAt()).add("PreviousActiveModelVersion", (Object)this.previousActiveModelVersion()).add("PreviousActiveModelVersionArn", (Object)this.previousActiveModelVersionArn()).add("PreviousModelVersionActivatedAt", (Object)this.previousModelVersionActivatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "LabelsInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelsInputConfiguration()));
            }
            case "TrainingDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataStartTime()));
            }
            case "TrainingDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataEndTime()));
            }
            case "EvaluationDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataStartTime()));
            }
            case "EvaluationDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataEndTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DataPreProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataPreProcessingConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TrainingExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingExecutionStartTime()));
            }
            case "TrainingExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingExecutionEndTime()));
            }
            case "FailedReason": {
                return Optional.ofNullable(clazz.cast(this.failedReason()));
            }
            case "ModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "OffCondition": {
                return Optional.ofNullable(clazz.cast(this.offCondition()));
            }
            case "SourceModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelVersionArn()));
            }
            case "ImportJobStartTime": {
                return Optional.ofNullable(clazz.cast(this.importJobStartTime()));
            }
            case "ImportJobEndTime": {
                return Optional.ofNullable(clazz.cast(this.importJobEndTime()));
            }
            case "ActiveModelVersion": {
                return Optional.ofNullable(clazz.cast(this.activeModelVersion()));
            }
            case "ActiveModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.activeModelVersionArn()));
            }
            case "ModelVersionActivatedAt": {
                return Optional.ofNullable(clazz.cast(this.modelVersionActivatedAt()));
            }
            case "PreviousActiveModelVersion": {
                return Optional.ofNullable(clazz.cast(this.previousActiveModelVersion()));
            }
            case "PreviousActiveModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.previousActiveModelVersionArn()));
            }
            case "PreviousModelVersionActivatedAt": {
                return Optional.ofNullable(clazz.cast(this.previousModelVersionActivatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelResponse, T> g) {
        return obj -> g.apply((DescribeModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private String datasetName;
        private String datasetArn;
        private String schema;
        private LabelsInputConfiguration labelsInputConfiguration;
        private Instant trainingDataStartTime;
        private Instant trainingDataEndTime;
        private Instant evaluationDataStartTime;
        private Instant evaluationDataEndTime;
        private String roleArn;
        private DataPreProcessingConfiguration dataPreProcessingConfiguration;
        private String status;
        private Instant trainingExecutionStartTime;
        private Instant trainingExecutionEndTime;
        private String failedReason;
        private String modelMetrics;
        private Instant lastUpdatedTime;
        private Instant createdAt;
        private String serverSideKmsKeyId;
        private String offCondition;
        private String sourceModelVersionArn;
        private Instant importJobStartTime;
        private Instant importJobEndTime;
        private Long activeModelVersion;
        private String activeModelVersionArn;
        private Instant modelVersionActivatedAt;
        private Long previousActiveModelVersion;
        private String previousActiveModelVersionArn;
        private Instant previousModelVersionActivatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelResponse model) {
            super(model);
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.datasetName(model.datasetName);
            this.datasetArn(model.datasetArn);
            this.schema(model.schema);
            this.labelsInputConfiguration(model.labelsInputConfiguration);
            this.trainingDataStartTime(model.trainingDataStartTime);
            this.trainingDataEndTime(model.trainingDataEndTime);
            this.evaluationDataStartTime(model.evaluationDataStartTime);
            this.evaluationDataEndTime(model.evaluationDataEndTime);
            this.roleArn(model.roleArn);
            this.dataPreProcessingConfiguration(model.dataPreProcessingConfiguration);
            this.status(model.status);
            this.trainingExecutionStartTime(model.trainingExecutionStartTime);
            this.trainingExecutionEndTime(model.trainingExecutionEndTime);
            this.failedReason(model.failedReason);
            this.modelMetrics(model.modelMetrics);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdAt(model.createdAt);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.offCondition(model.offCondition);
            this.sourceModelVersionArn(model.sourceModelVersionArn);
            this.importJobStartTime(model.importJobStartTime);
            this.importJobEndTime(model.importJobEndTime);
            this.activeModelVersion(model.activeModelVersion);
            this.activeModelVersionArn(model.activeModelVersionArn);
            this.modelVersionActivatedAt(model.modelVersionActivatedAt);
            this.previousActiveModelVersion(model.previousActiveModelVersion);
            this.previousActiveModelVersionArn(model.previousActiveModelVersionArn);
            this.previousModelVersionActivatedAt(model.previousModelVersionActivatedAt);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return this.labelsInputConfiguration != null ? this.labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return this.trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return this.trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final Instant getEvaluationDataStartTime() {
            return this.evaluationDataStartTime;
        }

        public final void setEvaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
        }

        @Override
        public final Builder evaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
            return this;
        }

        public final Instant getEvaluationDataEndTime() {
            return this.evaluationDataEndTime;
        }

        public final void setEvaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
        }

        @Override
        public final Builder evaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPreProcessingConfiguration.Builder getDataPreProcessingConfiguration() {
            return this.dataPreProcessingConfiguration != null ? this.dataPreProcessingConfiguration.toBuilder() : null;
        }

        public final void setDataPreProcessingConfiguration(DataPreProcessingConfiguration.BuilderImpl dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.build() : null;
        }

        @Override
        public final Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getTrainingExecutionStartTime() {
            return this.trainingExecutionStartTime;
        }

        public final void setTrainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
        }

        @Override
        public final Builder trainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
            return this;
        }

        public final Instant getTrainingExecutionEndTime() {
            return this.trainingExecutionEndTime;
        }

        public final void setTrainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
        }

        @Override
        public final Builder trainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
            return this;
        }

        public final String getFailedReason() {
            return this.failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final String getModelMetrics() {
            return this.modelMetrics;
        }

        public final void setModelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
        }

        @Override
        public final Builder modelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getOffCondition() {
            return this.offCondition;
        }

        public final void setOffCondition(String offCondition) {
            this.offCondition = offCondition;
        }

        @Override
        public final Builder offCondition(String offCondition) {
            this.offCondition = offCondition;
            return this;
        }

        public final String getSourceModelVersionArn() {
            return this.sourceModelVersionArn;
        }

        public final void setSourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
        }

        @Override
        public final Builder sourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
            return this;
        }

        public final Instant getImportJobStartTime() {
            return this.importJobStartTime;
        }

        public final void setImportJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
        }

        @Override
        public final Builder importJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
            return this;
        }

        public final Instant getImportJobEndTime() {
            return this.importJobEndTime;
        }

        public final void setImportJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
        }

        @Override
        public final Builder importJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
            return this;
        }

        public final Long getActiveModelVersion() {
            return this.activeModelVersion;
        }

        public final void setActiveModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
        }

        @Override
        public final Builder activeModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
            return this;
        }

        public final String getActiveModelVersionArn() {
            return this.activeModelVersionArn;
        }

        public final void setActiveModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
        }

        @Override
        public final Builder activeModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
            return this;
        }

        public final Instant getModelVersionActivatedAt() {
            return this.modelVersionActivatedAt;
        }

        public final void setModelVersionActivatedAt(Instant modelVersionActivatedAt) {
            this.modelVersionActivatedAt = modelVersionActivatedAt;
        }

        @Override
        public final Builder modelVersionActivatedAt(Instant modelVersionActivatedAt) {
            this.modelVersionActivatedAt = modelVersionActivatedAt;
            return this;
        }

        public final Long getPreviousActiveModelVersion() {
            return this.previousActiveModelVersion;
        }

        public final void setPreviousActiveModelVersion(Long previousActiveModelVersion) {
            this.previousActiveModelVersion = previousActiveModelVersion;
        }

        @Override
        public final Builder previousActiveModelVersion(Long previousActiveModelVersion) {
            this.previousActiveModelVersion = previousActiveModelVersion;
            return this;
        }

        public final String getPreviousActiveModelVersionArn() {
            return this.previousActiveModelVersionArn;
        }

        public final void setPreviousActiveModelVersionArn(String previousActiveModelVersionArn) {
            this.previousActiveModelVersionArn = previousActiveModelVersionArn;
        }

        @Override
        public final Builder previousActiveModelVersionArn(String previousActiveModelVersionArn) {
            this.previousActiveModelVersionArn = previousActiveModelVersionArn;
            return this;
        }

        public final Instant getPreviousModelVersionActivatedAt() {
            return this.previousModelVersionActivatedAt;
        }

        public final void setPreviousModelVersionActivatedAt(Instant previousModelVersionActivatedAt) {
            this.previousModelVersionActivatedAt = previousModelVersionActivatedAt;
        }

        @Override
        public final Builder previousModelVersionActivatedAt(Instant previousModelVersionActivatedAt) {
            this.previousModelVersionActivatedAt = previousModelVersionActivatedAt;
            return this;
        }

        @Override
        public DescribeModelResponse build() {
            return new DescribeModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelResponse> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder datasetName(String var1);

        public Builder datasetArn(String var1);

        public Builder schema(String var1);

        public Builder labelsInputConfiguration(LabelsInputConfiguration var1);

        default public Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return this.labelsInputConfiguration((LabelsInputConfiguration)((LabelsInputConfiguration.Builder)LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration)).build());
        }

        public Builder trainingDataStartTime(Instant var1);

        public Builder trainingDataEndTime(Instant var1);

        public Builder evaluationDataStartTime(Instant var1);

        public Builder evaluationDataEndTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration var1);

        default public Builder dataPreProcessingConfiguration(Consumer<DataPreProcessingConfiguration.Builder> dataPreProcessingConfiguration) {
            return this.dataPreProcessingConfiguration((DataPreProcessingConfiguration)((DataPreProcessingConfiguration.Builder)DataPreProcessingConfiguration.builder().applyMutation(dataPreProcessingConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder trainingExecutionStartTime(Instant var1);

        public Builder trainingExecutionEndTime(Instant var1);

        public Builder failedReason(String var1);

        public Builder modelMetrics(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder serverSideKmsKeyId(String var1);

        public Builder offCondition(String var1);

        public Builder sourceModelVersionArn(String var1);

        public Builder importJobStartTime(Instant var1);

        public Builder importJobEndTime(Instant var1);

        public Builder activeModelVersion(Long var1);

        public Builder activeModelVersionArn(String var1);

        public Builder modelVersionActivatedAt(Instant var1);

        public Builder previousActiveModelVersion(Long var1);

        public Builder previousActiveModelVersionArn(String var1);

        public Builder previousModelVersionActivatedAt(Instant var1);
    }
}

