/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.IngestionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIngestionJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIngestionJobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(DataIngestionJobSummary.getter(DataIngestionJobSummary::jobId)).setter(DataIngestionJobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DataIngestionJobSummary.getter(DataIngestionJobSummary::datasetName)).setter(DataIngestionJobSummary.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DataIngestionJobSummary.getter(DataIngestionJobSummary::datasetArn)).setter(DataIngestionJobSummary.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngestionInputConfiguration").getter(DataIngestionJobSummary.getter(DataIngestionJobSummary::ingestionInputConfiguration)).setter(DataIngestionJobSummary.setter(Builder::ingestionInputConfiguration)).constructor(IngestionInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DataIngestionJobSummary.getter(DataIngestionJobSummary::statusAsString)).setter(DataIngestionJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, DATASET_NAME_FIELD, DATASET_ARN_FIELD, INGESTION_INPUT_CONFIGURATION_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String datasetName;
    private final String datasetArn;
    private final IngestionInputConfiguration ingestionInputConfiguration;
    private final String status;

    private DataIngestionJobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.status = builder.status;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return this.ingestionInputConfiguration;
    }

    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIngestionJobSummary)) {
            return false;
        }
        DataIngestionJobSummary other = (DataIngestionJobSummary)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.ingestionInputConfiguration(), other.ingestionInputConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataIngestionJobSummary").add("JobId", (Object)this.jobId()).add("DatasetName", (Object)this.datasetName()).add("DatasetArn", (Object)this.datasetArn()).add("IngestionInputConfiguration", (Object)this.ingestionInputConfiguration()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "IngestionInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingestionInputConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataIngestionJobSummary, T> g) {
        return obj -> g.apply((DataIngestionJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String datasetName;
        private String datasetArn;
        private IngestionInputConfiguration ingestionInputConfiguration;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIngestionJobSummary model) {
            this.jobId(model.jobId);
            this.datasetName(model.datasetName);
            this.datasetArn(model.datasetArn);
            this.ingestionInputConfiguration(model.ingestionInputConfiguration);
            this.status(model.status);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return this.ingestionInputConfiguration != null ? this.ingestionInputConfiguration.toBuilder() : null;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public DataIngestionJobSummary build() {
            return new DataIngestionJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIngestionJobSummary> {
        public Builder jobId(String var1);

        public Builder datasetName(String var1);

        public Builder datasetArn(String var1);

        public Builder ingestionInputConfiguration(IngestionInputConfiguration var1);

        default public Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return this.ingestionInputConfiguration((IngestionInputConfiguration)((IngestionInputConfiguration.Builder)IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(IngestionJobStatus var1);
    }
}

