/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.Tag;
import software.amazon.awssdk.services.lookoutequipment.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, CreateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetName)).setter(CreateDatasetRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<DatasetSchema> DATASET_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetSchema").getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetSchema)).setter(CreateDatasetRequest.setter(Builder::datasetSchema)).constructor(DatasetSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSchema").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(CreateDatasetRequest.getter(CreateDatasetRequest::serverSideKmsKeyId)).setter(CreateDatasetRequest.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateDatasetRequest.getter(CreateDatasetRequest::clientToken)).setter(CreateDatasetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDatasetRequest.getter(CreateDatasetRequest::tags)).setter(CreateDatasetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, DATASET_SCHEMA_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String datasetName;
    private final DatasetSchema datasetSchema;
    private final String serverSideKmsKeyId;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.datasetSchema = builder.datasetSchema;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final DatasetSchema datasetSchema() {
        return this.datasetSchema;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)((Object)obj);
        return Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetSchema(), other.datasetSchema()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetRequest").add("DatasetName", (Object)this.datasetName()).add("DatasetSchema", (Object)this.datasetSchema()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetSchema": {
                return Optional.ofNullable(clazz.cast(this.datasetSchema()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String datasetName;
        private DatasetSchema datasetSchema;
        private String serverSideKmsKeyId;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            this.datasetName(model.datasetName);
            this.datasetSchema(model.datasetSchema);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final DatasetSchema.Builder getDatasetSchema() {
            return this.datasetSchema != null ? this.datasetSchema.toBuilder() : null;
        }

        public final void setDatasetSchema(DatasetSchema.BuilderImpl datasetSchema) {
            this.datasetSchema = datasetSchema != null ? datasetSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder datasetSchema(DatasetSchema datasetSchema) {
            this.datasetSchema = datasetSchema;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        @Transient
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetRequest> {
        public Builder datasetName(String var1);

        public Builder datasetSchema(DatasetSchema var1);

        default public Builder datasetSchema(Consumer<DatasetSchema.Builder> datasetSchema) {
            return this.datasetSchema((DatasetSchema)((DatasetSchema.Builder)DatasetSchema.builder().applyMutation(datasetSchema)).build());
        }

        public Builder serverSideKmsKeyId(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

