/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceS3OutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceOutputConfiguration> {
    private static final SdkField<InferenceS3OutputConfiguration> S3_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3OutputConfiguration").getter(InferenceOutputConfiguration.getter(InferenceOutputConfiguration::s3OutputConfiguration)).setter(InferenceOutputConfiguration.setter(Builder::s3OutputConfiguration)).constructor(InferenceS3OutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputConfiguration").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(InferenceOutputConfiguration.getter(InferenceOutputConfiguration::kmsKeyId)).setter(InferenceOutputConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_CONFIGURATION_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final InferenceS3OutputConfiguration s3OutputConfiguration;
    private final String kmsKeyId;

    private InferenceOutputConfiguration(BuilderImpl builder) {
        this.s3OutputConfiguration = builder.s3OutputConfiguration;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final InferenceS3OutputConfiguration s3OutputConfiguration() {
        return this.s3OutputConfiguration;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceOutputConfiguration)) {
            return false;
        }
        InferenceOutputConfiguration other = (InferenceOutputConfiguration)obj;
        return Objects.equals(this.s3OutputConfiguration(), other.s3OutputConfiguration()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceOutputConfiguration").add("S3OutputConfiguration", (Object)this.s3OutputConfiguration()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3OutputConfiguration()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceOutputConfiguration, T> g) {
        return obj -> g.apply((InferenceOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InferenceS3OutputConfiguration s3OutputConfiguration;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceOutputConfiguration model) {
            this.s3OutputConfiguration(model.s3OutputConfiguration);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final InferenceS3OutputConfiguration.Builder getS3OutputConfiguration() {
            return this.s3OutputConfiguration != null ? this.s3OutputConfiguration.toBuilder() : null;
        }

        public final void setS3OutputConfiguration(InferenceS3OutputConfiguration.BuilderImpl s3OutputConfiguration) {
            this.s3OutputConfiguration = s3OutputConfiguration != null ? s3OutputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder s3OutputConfiguration(InferenceS3OutputConfiguration s3OutputConfiguration) {
            this.s3OutputConfiguration = s3OutputConfiguration;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public InferenceOutputConfiguration build() {
            return new InferenceOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceOutputConfiguration> {
        public Builder s3OutputConfiguration(InferenceS3OutputConfiguration var1);

        default public Builder s3OutputConfiguration(Consumer<InferenceS3OutputConfiguration.Builder> s3OutputConfiguration) {
            return this.s3OutputConfiguration((InferenceS3OutputConfiguration)((InferenceS3OutputConfiguration.Builder)InferenceS3OutputConfiguration.builder().applyMutation(s3OutputConfiguration)).build());
        }

        public Builder kmsKeyId(String var1);
    }
}

