/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceInputNameConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceS3InputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceInputConfiguration> {
    private static final SdkField<InferenceS3InputConfiguration> S3_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3InputConfiguration").getter(InferenceInputConfiguration.getter(InferenceInputConfiguration::s3InputConfiguration)).setter(InferenceInputConfiguration.setter(Builder::s3InputConfiguration)).constructor(InferenceS3InputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputConfiguration").build()}).build();
    private static final SdkField<String> INPUT_TIME_ZONE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputTimeZoneOffset").getter(InferenceInputConfiguration.getter(InferenceInputConfiguration::inputTimeZoneOffset)).setter(InferenceInputConfiguration.setter(Builder::inputTimeZoneOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTimeZoneOffset").build()}).build();
    private static final SdkField<InferenceInputNameConfiguration> INFERENCE_INPUT_NAME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceInputNameConfiguration").getter(InferenceInputConfiguration.getter(InferenceInputConfiguration::inferenceInputNameConfiguration)).setter(InferenceInputConfiguration.setter(Builder::inferenceInputNameConfiguration)).constructor(InferenceInputNameConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceInputNameConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_CONFIGURATION_FIELD, INPUT_TIME_ZONE_OFFSET_FIELD, INFERENCE_INPUT_NAME_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final InferenceS3InputConfiguration s3InputConfiguration;
    private final String inputTimeZoneOffset;
    private final InferenceInputNameConfiguration inferenceInputNameConfiguration;

    private InferenceInputConfiguration(BuilderImpl builder) {
        this.s3InputConfiguration = builder.s3InputConfiguration;
        this.inputTimeZoneOffset = builder.inputTimeZoneOffset;
        this.inferenceInputNameConfiguration = builder.inferenceInputNameConfiguration;
    }

    public final InferenceS3InputConfiguration s3InputConfiguration() {
        return this.s3InputConfiguration;
    }

    public final String inputTimeZoneOffset() {
        return this.inputTimeZoneOffset;
    }

    public final InferenceInputNameConfiguration inferenceInputNameConfiguration() {
        return this.inferenceInputNameConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTimeZoneOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceInputNameConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceInputConfiguration)) {
            return false;
        }
        InferenceInputConfiguration other = (InferenceInputConfiguration)obj;
        return Objects.equals(this.s3InputConfiguration(), other.s3InputConfiguration()) && Objects.equals(this.inputTimeZoneOffset(), other.inputTimeZoneOffset()) && Objects.equals(this.inferenceInputNameConfiguration(), other.inferenceInputNameConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceInputConfiguration").add("S3InputConfiguration", (Object)this.s3InputConfiguration()).add("InputTimeZoneOffset", (Object)this.inputTimeZoneOffset()).add("InferenceInputNameConfiguration", (Object)this.inferenceInputNameConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3InputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3InputConfiguration()));
            }
            case "InputTimeZoneOffset": {
                return Optional.ofNullable(clazz.cast(this.inputTimeZoneOffset()));
            }
            case "InferenceInputNameConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceInputNameConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceInputConfiguration, T> g) {
        return obj -> g.apply((InferenceInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InferenceS3InputConfiguration s3InputConfiguration;
        private String inputTimeZoneOffset;
        private InferenceInputNameConfiguration inferenceInputNameConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceInputConfiguration model) {
            this.s3InputConfiguration(model.s3InputConfiguration);
            this.inputTimeZoneOffset(model.inputTimeZoneOffset);
            this.inferenceInputNameConfiguration(model.inferenceInputNameConfiguration);
        }

        public final InferenceS3InputConfiguration.Builder getS3InputConfiguration() {
            return this.s3InputConfiguration != null ? this.s3InputConfiguration.toBuilder() : null;
        }

        public final void setS3InputConfiguration(InferenceS3InputConfiguration.BuilderImpl s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration != null ? s3InputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder s3InputConfiguration(InferenceS3InputConfiguration s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration;
            return this;
        }

        public final String getInputTimeZoneOffset() {
            return this.inputTimeZoneOffset;
        }

        public final void setInputTimeZoneOffset(String inputTimeZoneOffset) {
            this.inputTimeZoneOffset = inputTimeZoneOffset;
        }

        @Override
        @Transient
        public final Builder inputTimeZoneOffset(String inputTimeZoneOffset) {
            this.inputTimeZoneOffset = inputTimeZoneOffset;
            return this;
        }

        public final InferenceInputNameConfiguration.Builder getInferenceInputNameConfiguration() {
            return this.inferenceInputNameConfiguration != null ? this.inferenceInputNameConfiguration.toBuilder() : null;
        }

        public final void setInferenceInputNameConfiguration(InferenceInputNameConfiguration.BuilderImpl inferenceInputNameConfiguration) {
            this.inferenceInputNameConfiguration = inferenceInputNameConfiguration != null ? inferenceInputNameConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder inferenceInputNameConfiguration(InferenceInputNameConfiguration inferenceInputNameConfiguration) {
            this.inferenceInputNameConfiguration = inferenceInputNameConfiguration;
            return this;
        }

        public InferenceInputConfiguration build() {
            return new InferenceInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceInputConfiguration> {
        public Builder s3InputConfiguration(InferenceS3InputConfiguration var1);

        default public Builder s3InputConfiguration(Consumer<InferenceS3InputConfiguration.Builder> s3InputConfiguration) {
            return this.s3InputConfiguration((InferenceS3InputConfiguration)((InferenceS3InputConfiguration.Builder)InferenceS3InputConfiguration.builder().applyMutation(s3InputConfiguration)).build());
        }

        public Builder inputTimeZoneOffset(String var1);

        public Builder inferenceInputNameConfiguration(InferenceInputNameConfiguration var1);

        default public Builder inferenceInputNameConfiguration(Consumer<InferenceInputNameConfiguration.Builder> inferenceInputNameConfiguration) {
            return this.inferenceInputNameConfiguration((InferenceInputNameConfiguration)((InferenceInputNameConfiguration.Builder)InferenceInputNameConfiguration.builder().applyMutation(inferenceInputNameConfiguration)).build());
        }
    }
}

