/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema;
import software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.Tag;
import software.amazon.awssdk.services.lookoutequipment.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, CreateModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(CreateModelRequest.getter(CreateModelRequest::modelName)).setter(CreateModelRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(CreateModelRequest.getter(CreateModelRequest::datasetName)).setter(CreateModelRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<DatasetSchema> DATASET_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetSchema").getter(CreateModelRequest.getter(CreateModelRequest::datasetSchema)).setter(CreateModelRequest.setter(Builder::datasetSchema)).constructor(DatasetSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSchema").build()}).build();
    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration").getter(CreateModelRequest.getter(CreateModelRequest::labelsInputConfiguration)).setter(CreateModelRequest.setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateModelRequest.getter(CreateModelRequest::clientToken)).setter(CreateModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingDataStartTime").getter(CreateModelRequest.getter(CreateModelRequest::trainingDataStartTime)).setter(CreateModelRequest.setter(Builder::trainingDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingDataEndTime").getter(CreateModelRequest.getter(CreateModelRequest::trainingDataEndTime)).setter(CreateModelRequest.setter(Builder::trainingDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataEndTime").build()}).build();
    private static final SdkField<Instant> EVALUATION_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationDataStartTime").getter(CreateModelRequest.getter(CreateModelRequest::evaluationDataStartTime)).setter(CreateModelRequest.setter(Builder::evaluationDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataStartTime").build()}).build();
    private static final SdkField<Instant> EVALUATION_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationDataEndTime").getter(CreateModelRequest.getter(CreateModelRequest::evaluationDataEndTime)).setter(CreateModelRequest.setter(Builder::evaluationDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataEndTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateModelRequest.getter(CreateModelRequest::roleArn)).setter(CreateModelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<DataPreProcessingConfiguration> DATA_PRE_PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPreProcessingConfiguration").getter(CreateModelRequest.getter(CreateModelRequest::dataPreProcessingConfiguration)).setter(CreateModelRequest.setter(Builder::dataPreProcessingConfiguration)).constructor(DataPreProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreProcessingConfiguration").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(CreateModelRequest.getter(CreateModelRequest::serverSideKmsKeyId)).setter(CreateModelRequest.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateModelRequest.getter(CreateModelRequest::tags)).setter(CreateModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, DATASET_NAME_FIELD, DATASET_SCHEMA_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, EVALUATION_DATA_START_TIME_FIELD, EVALUATION_DATA_END_TIME_FIELD, ROLE_ARN_FIELD, DATA_PRE_PROCESSING_CONFIGURATION_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, TAGS_FIELD));
    private final String modelName;
    private final String datasetName;
    private final DatasetSchema datasetSchema;
    private final LabelsInputConfiguration labelsInputConfiguration;
    private final String clientToken;
    private final Instant trainingDataStartTime;
    private final Instant trainingDataEndTime;
    private final Instant evaluationDataStartTime;
    private final Instant evaluationDataEndTime;
    private final String roleArn;
    private final DataPreProcessingConfiguration dataPreProcessingConfiguration;
    private final String serverSideKmsKeyId;
    private final List<Tag> tags;

    private CreateModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.datasetName = builder.datasetName;
        this.datasetSchema = builder.datasetSchema;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.clientToken = builder.clientToken;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.evaluationDataStartTime = builder.evaluationDataStartTime;
        this.evaluationDataEndTime = builder.evaluationDataEndTime;
        this.roleArn = builder.roleArn;
        this.dataPreProcessingConfiguration = builder.dataPreProcessingConfiguration;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.tags = builder.tags;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final DatasetSchema datasetSchema() {
        return this.datasetSchema;
    }

    public final LabelsInputConfiguration labelsInputConfiguration() {
        return this.labelsInputConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant trainingDataStartTime() {
        return this.trainingDataStartTime;
    }

    public final Instant trainingDataEndTime() {
        return this.trainingDataEndTime;
    }

    public final Instant evaluationDataStartTime() {
        return this.evaluationDataStartTime;
    }

    public final Instant evaluationDataEndTime() {
        return this.evaluationDataEndTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DataPreProcessingConfiguration dataPreProcessingConfiguration() {
        return this.dataPreProcessingConfiguration;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPreProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetSchema(), other.datasetSchema()) && Objects.equals(this.labelsInputConfiguration(), other.labelsInputConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.trainingDataStartTime(), other.trainingDataStartTime()) && Objects.equals(this.trainingDataEndTime(), other.trainingDataEndTime()) && Objects.equals(this.evaluationDataStartTime(), other.evaluationDataStartTime()) && Objects.equals(this.evaluationDataEndTime(), other.evaluationDataEndTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataPreProcessingConfiguration(), other.dataPreProcessingConfiguration()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelRequest").add("ModelName", (Object)this.modelName()).add("DatasetName", (Object)this.datasetName()).add("DatasetSchema", (Object)this.datasetSchema()).add("LabelsInputConfiguration", (Object)this.labelsInputConfiguration()).add("ClientToken", (Object)this.clientToken()).add("TrainingDataStartTime", (Object)this.trainingDataStartTime()).add("TrainingDataEndTime", (Object)this.trainingDataEndTime()).add("EvaluationDataStartTime", (Object)this.evaluationDataStartTime()).add("EvaluationDataEndTime", (Object)this.evaluationDataEndTime()).add("RoleArn", (Object)this.roleArn()).add("DataPreProcessingConfiguration", (Object)this.dataPreProcessingConfiguration()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetSchema": {
                return Optional.ofNullable(clazz.cast(this.datasetSchema()));
            }
            case "LabelsInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelsInputConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "TrainingDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataStartTime()));
            }
            case "TrainingDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataEndTime()));
            }
            case "EvaluationDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataStartTime()));
            }
            case "EvaluationDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataEndTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DataPreProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataPreProcessingConfiguration()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelRequest, T> g) {
        return obj -> g.apply((CreateModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private String datasetName;
        private DatasetSchema datasetSchema;
        private LabelsInputConfiguration labelsInputConfiguration;
        private String clientToken;
        private Instant trainingDataStartTime;
        private Instant trainingDataEndTime;
        private Instant evaluationDataStartTime;
        private Instant evaluationDataEndTime;
        private String roleArn;
        private DataPreProcessingConfiguration dataPreProcessingConfiguration;
        private String serverSideKmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.datasetName(model.datasetName);
            this.datasetSchema(model.datasetSchema);
            this.labelsInputConfiguration(model.labelsInputConfiguration);
            this.clientToken(model.clientToken);
            this.trainingDataStartTime(model.trainingDataStartTime);
            this.trainingDataEndTime(model.trainingDataEndTime);
            this.evaluationDataStartTime(model.evaluationDataStartTime);
            this.evaluationDataEndTime(model.evaluationDataEndTime);
            this.roleArn(model.roleArn);
            this.dataPreProcessingConfiguration(model.dataPreProcessingConfiguration);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.tags(model.tags);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final DatasetSchema.Builder getDatasetSchema() {
            return this.datasetSchema != null ? this.datasetSchema.toBuilder() : null;
        }

        public final void setDatasetSchema(DatasetSchema.BuilderImpl datasetSchema) {
            this.datasetSchema = datasetSchema != null ? datasetSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder datasetSchema(DatasetSchema datasetSchema) {
            this.datasetSchema = datasetSchema;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return this.labelsInputConfiguration != null ? this.labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return this.trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        @Transient
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return this.trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        @Transient
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final Instant getEvaluationDataStartTime() {
            return this.evaluationDataStartTime;
        }

        public final void setEvaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
        }

        @Override
        @Transient
        public final Builder evaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
            return this;
        }

        public final Instant getEvaluationDataEndTime() {
            return this.evaluationDataEndTime;
        }

        public final void setEvaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
        }

        @Override
        @Transient
        public final Builder evaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPreProcessingConfiguration.Builder getDataPreProcessingConfiguration() {
            return this.dataPreProcessingConfiguration != null ? this.dataPreProcessingConfiguration.toBuilder() : null;
        }

        public final void setDataPreProcessingConfiguration(DataPreProcessingConfiguration.BuilderImpl dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        @Transient
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelRequest> {
        public Builder modelName(String var1);

        public Builder datasetName(String var1);

        public Builder datasetSchema(DatasetSchema var1);

        default public Builder datasetSchema(Consumer<DatasetSchema.Builder> datasetSchema) {
            return this.datasetSchema((DatasetSchema)((DatasetSchema.Builder)DatasetSchema.builder().applyMutation(datasetSchema)).build());
        }

        public Builder labelsInputConfiguration(LabelsInputConfiguration var1);

        default public Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return this.labelsInputConfiguration((LabelsInputConfiguration)((LabelsInputConfiguration.Builder)LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder trainingDataStartTime(Instant var1);

        public Builder trainingDataEndTime(Instant var1);

        public Builder evaluationDataStartTime(Instant var1);

        public Builder evaluationDataEndTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration var1);

        default public Builder dataPreProcessingConfiguration(Consumer<DataPreProcessingConfiguration.Builder> dataPreProcessingConfiguration) {
            return this.dataPreProcessingConfiguration((DataPreProcessingConfiguration)((DataPreProcessingConfiguration.Builder)DataPreProcessingConfiguration.builder().applyMutation(dataPreProcessingConfiguration)).build());
        }

        public Builder serverSideKmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

