/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataIngestionJobsResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListDataIngestionJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataIngestionJobsResponse.getter(ListDataIngestionJobsResponse::nextToken)).setter(ListDataIngestionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DataIngestionJobSummary>> DATA_INGESTION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataIngestionJobSummaries").getter(ListDataIngestionJobsResponse.getter(ListDataIngestionJobsResponse::dataIngestionJobSummaries)).setter(ListDataIngestionJobsResponse.setter(Builder::dataIngestionJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIngestionJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataIngestionJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DATA_INGESTION_JOB_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<DataIngestionJobSummary> dataIngestionJobSummaries;

    private ListDataIngestionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dataIngestionJobSummaries = builder.dataIngestionJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDataIngestionJobSummaries() {
        return this.dataIngestionJobSummaries != null && !(this.dataIngestionJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<DataIngestionJobSummary> dataIngestionJobSummaries() {
        return this.dataIngestionJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataIngestionJobSummaries() ? this.dataIngestionJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataIngestionJobsResponse)) {
            return false;
        }
        ListDataIngestionJobsResponse other = (ListDataIngestionJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDataIngestionJobSummaries() == other.hasDataIngestionJobSummaries() && Objects.equals(this.dataIngestionJobSummaries(), other.dataIngestionJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataIngestionJobsResponse").add("NextToken", (Object)this.nextToken()).add("DataIngestionJobSummaries", this.hasDataIngestionJobSummaries() ? this.dataIngestionJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DataIngestionJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataIngestionJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataIngestionJobsResponse, T> g) {
        return obj -> g.apply((ListDataIngestionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DataIngestionJobSummary> dataIngestionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataIngestionJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dataIngestionJobSummaries(model.dataIngestionJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<DataIngestionJobSummary.Builder> getDataIngestionJobSummaries() {
            if (this.dataIngestionJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataIngestionJobSummaries != null ? (Collection)this.dataIngestionJobSummaries.stream().map(DataIngestionJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataIngestionJobSummaries(Collection<DataIngestionJobSummary> dataIngestionJobSummaries) {
            this.dataIngestionJobSummaries = DataIngestionJobSummariesCopier.copy(dataIngestionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataIngestionJobSummaries(DataIngestionJobSummary ... dataIngestionJobSummaries) {
            this.dataIngestionJobSummaries(Arrays.asList(dataIngestionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataIngestionJobSummaries(Consumer<DataIngestionJobSummary.Builder> ... dataIngestionJobSummaries) {
            this.dataIngestionJobSummaries(Stream.of(dataIngestionJobSummaries).map(c -> (DataIngestionJobSummary)((DataIngestionJobSummary.Builder)DataIngestionJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataIngestionJobSummaries(Collection<DataIngestionJobSummary.BuilderImpl> dataIngestionJobSummaries) {
            this.dataIngestionJobSummaries = DataIngestionJobSummariesCopier.copyFromBuilder(dataIngestionJobSummaries);
        }

        @Override
        public ListDataIngestionJobsResponse build() {
            return new ListDataIngestionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataIngestionJobsResponse> {
        public Builder nextToken(String var1);

        public Builder dataIngestionJobSummaries(Collection<DataIngestionJobSummary> var1);

        public Builder dataIngestionJobSummaries(DataIngestionJobSummary ... var1);

        public Builder dataIngestionJobSummaries(Consumer<DataIngestionJobSummary.Builder> ... var1);
    }
}

