/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AndroidApp
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AndroidApp> {
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Package").getter(AndroidApp.getter(AndroidApp::packageValue)).setter(AndroidApp.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Package").build()}).build();
    private static final SdkField<String> CERTIFICATE_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateFingerprint").getter(AndroidApp.getter(AndroidApp::certificateFingerprint)).setter(AndroidApp.setter(Builder::certificateFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateFingerprint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_FIELD, CERTIFICATE_FINGERPRINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AndroidApp.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String packageValue;
    private final String certificateFingerprint;

    private AndroidApp(BuilderImpl builder) {
        this.packageValue = builder.packageValue;
        this.certificateFingerprint = builder.certificateFingerprint;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final String certificateFingerprint() {
        return this.certificateFingerprint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateFingerprint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AndroidApp)) {
            return false;
        }
        AndroidApp other = (AndroidApp)obj;
        return Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.certificateFingerprint(), other.certificateFingerprint());
    }

    public final String toString() {
        return ToString.builder((String)"AndroidApp").add("Package", (Object)this.packageValue()).add("CertificateFingerprint", (Object)this.certificateFingerprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "CertificateFingerprint": {
                return Optional.ofNullable(clazz.cast(this.certificateFingerprint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Package", PACKAGE_FIELD);
        map.put("CertificateFingerprint", CERTIFICATE_FINGERPRINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AndroidApp, T> g) {
        return obj -> g.apply((AndroidApp)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageValue;
        private String certificateFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(AndroidApp model) {
            this.packageValue(model.packageValue);
            this.certificateFingerprint(model.certificateFingerprint);
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getCertificateFingerprint() {
            return this.certificateFingerprint;
        }

        public final void setCertificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
        }

        @Override
        public final Builder certificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
            return this;
        }

        public AndroidApp build() {
            return new AndroidApp(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AndroidApp> {
        public Builder packageValue(String var1);

        public Builder certificateFingerprint(String var1);
    }
}

